/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;

public class ChangeTreeProvider {
    public ResourceSetRecording createChangeTree(ResourceSet resourceSet, Collection<IResourceSnapshot> snapshots, ChangeDescription desc) {
        ResourceRecording recording;
        Resource resource;
        ResourceSetRecording rs = new ResourceSetRecording(resourceSet);
        LinkedHashMap result = Maps.newLinkedHashMap();
        LinkedHashMap objectChanges = Maps.newLinkedHashMap();
        for (IResourceSnapshot snap : snapshots) {
            resource = snap.getResource();
            recording = new ResourceRecording(rs, resource);
            recording.snapshot = snap;
            result.put(resource, recording);
        }
        for (ResourceChange rc : desc.getResourceChanges()) {
            resource = rc.getResource();
            recording = (ResourceRecording)result.get(resource);
            if (recording == null) {
                recording = new ResourceRecording(rs, resource);
                result.put(resource, recording);
            }
            recording.resourceChange = rc;
        }
        for (Map.Entry e : desc.getObjectChanges().entrySet()) {
            EList featureChange = (EList)e.getValue();
            EObject object = (EObject)e.getKey();
            objectChanges.put(object, new EObjectChange(object, (EList<FeatureChange>)featureChange));
        }
        Iterator iterator = Lists.newArrayList(objectChanges.values()).iterator();
        block3: while (iterator.hasNext()) {
            EObject container;
            EObjectChange change;
            EObjectChange current = change = (EObjectChange)iterator.next();
            while ((container = current.eObject.eContainer()) != null) {
                EObjectChange next = (EObjectChange)objectChanges.get(container);
                if (next == null) {
                    next = new EObjectChange(container);
                    next.children.add(current);
                    objectChanges.put(container, next);
                } else if (!next.children.add(current)) continue block3;
                current = next;
            }
            Resource resource2 = current.eObject.eResource();
            ResourceRecording resourceChange = (ResourceRecording)result.get(resource2);
            if (resourceChange == null) {
                resourceChange = new ResourceRecording(rs, resource2);
                result.put(resource2, resourceChange);
            }
            resourceChange.roots.add(current);
        }
        rs.resources = ImmutableList.copyOf(result.values());
        rs.objects = ImmutableMap.copyOf((Map)objectChanges);
        return rs;
    }

    public static class ResourceSetRecording {
        private Map<EObject, EObjectChange> objects;
        private List<ResourceRecording> resources = Lists.newArrayList();
        private final ResourceSet resourceSet;

        public ResourceSetRecording(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        public Map<EObject, EObjectChange> getAllEObjectRecordings() {
            return this.objects;
        }

        public ResourceRecording getRecordedResource(Resource resource) {
            for (ResourceRecording r : this.resources) {
                if (r.resource != resource) continue;
                return r;
            }
            return null;
        }

        public List<ResourceRecording> getRecordedResources() {
            return this.resources;
        }

        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }
    }

    public static class ResourceRecording {
        private final Resource resource;
        private ResourceChange resourceChange;
        private final ResourceSetRecording resourceSetRecording;
        private final Set<EObjectChange> roots = Sets.newLinkedHashSet();
        private IResourceSnapshot snapshot;

        public ResourceRecording(ResourceSetRecording rsRecording, Resource resource) {
            this.resourceSetRecording = rsRecording;
            this.resource = resource;
        }

        public List<EObjectChange> getAllEObjectRecordings() {
            LinkedList<EObjectChange> todo = new LinkedList<EObjectChange>();
            todo.addAll(this.roots);
            ArrayList result = Lists.newArrayList();
            while (!todo.isEmpty()) {
                EObjectChange next = (EObjectChange)todo.pop();
                result.add(next);
                todo.addAll(next.getChildren());
            }
            return result;
        }

        public Resource getResource() {
            return this.resource;
        }

        public ResourceChange getResourceChange() {
            return this.resourceChange;
        }

        public ResourceSetRecording getResourceSetRecording() {
            return this.resourceSetRecording;
        }

        public List<EObjectChange> getRootEObjectRecordings() {
            return ImmutableList.copyOf(this.roots);
        }

        public IResourceSnapshot getSnapshot() {
            return this.snapshot;
        }
    }

    public class EObjectChange {
        private final EList<FeatureChange> changes;
        private final Set<EObjectChange> children = Sets.newLinkedHashSet();
        private final EObject eObject;

        public EObjectChange(EObject eObject) {
            this(eObject, (EList<FeatureChange>)ECollections.emptyEList());
        }

        public EObjectChange(EObject eObject, EList<FeatureChange> changes) {
            Preconditions.checkNotNull((Object)eObject);
            this.eObject = eObject;
            this.changes = changes;
        }

        public EList<FeatureChange> getChanges() {
            return this.changes == null ? ECollections.emptyEList() : this.changes;
        }

        public Set<EObjectChange> getChildren() {
            return ImmutableSet.copyOf(this.children);
        }

        public EObject getEObject() {
            return this.eObject;
        }
    }
}

