/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.util.Strings;

public class FQNPrefixMatcher
implements IPrefixMatcher {
    @Inject
    private IPrefixMatcher.IgnoreCase delegate;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    @Override
    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
            return true;
        }
        String delimiter = this.getDelimiter();
        if (!Strings.isEmpty((String)delimiter) && name.indexOf(delimiter) >= 0) {
            if (prefix.indexOf(delimiter) < 0) {
                String lastSegment = this.getLastSegment(name, delimiter);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                List splitPrefix = Strings.split((String)prefix, (String)delimiter);
                if (splitPrefix.isEmpty()) {
                    return false;
                }
                List splitName = Strings.split((String)name, (String)delimiter);
                if (splitName.size() < splitPrefix.size()) {
                    return false;
                }
                for (int i = 0; i < splitPrefix.size(); ++i) {
                    if (this.delegate.isCandidateMatchingPrefix((String)splitName.get(i), (String)splitPrefix.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected String getLastSegment(String fqn, String delimiter) {
        int lastDelimIndex = fqn.lastIndexOf(delimiter);
        if (lastDelimIndex >= 0 && lastDelimIndex + delimiter.length() < fqn.length()) {
            return fqn.substring(lastDelimIndex + delimiter.length());
        }
        return null;
    }

    public String getDelimiter() {
        if (this.qualifiedNameConverter instanceof IQualifiedNameConverter.DefaultImpl) {
            return ((IQualifiedNameConverter.DefaultImpl)this.qualifiedNameConverter).getDelimiter();
        }
        return ".";
    }

    public IPrefixMatcher.IgnoreCase getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IPrefixMatcher.IgnoreCase delegate) {
        this.delegate = delegate;
    }
}

