/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.quickfix;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticModificationContext;
import org.eclipse.xtext.ide.editor.quickfix.DiagnosticResolution;
import org.eclipse.xtext.ide.editor.quickfix.ITextModification;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

public class DiagnosticResolutionAcceptor {
    private List<DiagnosticResolution> resolutions = new ArrayList<DiagnosticResolution>();
    private DiagnosticModificationContext.Factory modificationContextFactory;

    @Inject
    public DiagnosticResolutionAcceptor(DiagnosticModificationContext.Factory modificationContextFactory) {
        this.modificationContextFactory = modificationContextFactory;
    }

    public void accept(String label, IChangeSerializer.IModification<EObject> modification) {
        this.resolutions.add(new DiagnosticResolution(label, this.modificationContextFactory, modification));
    }

    public void accept(String label, ITextModification modification) {
        this.resolutions.add(new DiagnosticResolution(label, this.modificationContextFactory, modification));
    }

    public List<DiagnosticResolution> getDiagnosticResolutions(ICodeActionService2.Options options) {
        this.resolutions.forEach(resolution -> resolution.configure(options));
        return this.resolutions;
    }
}

