/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.util.Ranges;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.rename.ChangeConverter2;
import org.eclipse.xtext.ide.server.rename.IRenameService2;
import org.eclipse.xtext.ide.server.rename.ServerRefactoringIssueAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Log
@Accessors(value={AccessorType.PROTECTED_GETTER})
public class RenameService2
implements IRenameService2 {
    @Inject
    @Extension
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private Provider<ServerRefactoringIssueAcceptor> issueProvider;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private TokenUtil tokenUtil;
    private Function<EObject, String> attributeResolver = SimpleAttributeResolver.newResolver(String.class, (String)"name");
    private static final Logger LOG = Logger.getLogger(RenameService2.class);

    @Override
    public WorkspaceEdit rename(IRenameService2.Options options) {
        try {
            TextDocumentIdentifier textDocument = options.getRenameParams().getTextDocument();
            String uri = textDocument.getUri();
            ServerRefactoringIssueAcceptor issueAcceptor = (ServerRefactoringIssueAcceptor)this.issueProvider.get();
            boolean shouldPrepareRename = this.shouldPrepareRename(options.getLanguageServerAccess());
            java.util.function.Function<ILanguageServerAccess.Context, WorkspaceEdit> _function = context -> {
                if (shouldPrepareRename) {
                    boolean _not;
                    CancelIndicator cancelIndicator;
                    Document document;
                    String _uri = textDocument.getUri();
                    TextDocumentIdentifier identifier = new TextDocumentIdentifier(_uri);
                    Position position = options.getRenameParams().getPosition();
                    PrepareRenameParams positionParams = new PrepareRenameParams(identifier, position);
                    Resource resource = context.getResource();
                    Either<Range, PrepareRenameResult> prepareRenameResult = this.doPrepareRename(resource, document = context.getDocument(), positionParams, cancelIndicator = options.getCancelIndicator());
                    boolean _mayPerformRename = this.mayPerformRename(prepareRenameResult, options.getRenameParams());
                    boolean bl = _not = !_mayPerformRename;
                    if (_not) {
                        return null;
                    }
                }
                WorkspaceEdit workspaceEdit = new WorkspaceEdit();
                ResourceSet resourceSet = options.getLanguageServerAccess().newLiveScopeResourceSet(context.getResource().getURI());
                Resource xtextResource = resourceSet.getResource(context.getResource().getURI(), true);
                if (xtextResource instanceof XtextResource) {
                    Position position_1 = options.getRenameParams().getPosition();
                    EObject element = null;
                    try {
                        element = this.getElementAtOffset((XtextResource)xtextResource, context.getDocument(), position_1);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof IndexOutOfBoundsException) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Invalid document ");
                            String _positionFragment = this.toPositionFragment(position_1, uri);
                            _builder.append(_positionFragment);
                            issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    if (element == null || element.eIsProxy()) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("No element found at ");
                        String _positionFragment = this.toPositionFragment(position_1, uri);
                        _builder.append(_positionFragment);
                        issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, _builder.toString(), new Object[0]);
                    } else {
                        IResourceServiceProvider services = this.serviceProviderRegistry.getResourceServiceProvider(element.eResource().getURI());
                        IChangeSerializer changeSerializer = (IChangeSerializer)services.get(IChangeSerializer.class);
                        String _newName = options.getRenameParams().getNewName();
                        URI _uRI = EcoreUtil.getURI((EObject)element);
                        RenameChange change = new RenameChange(_newName, _uRI);
                        RenameContext renameContext = new RenameContext(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new RenameChange[]{change})), resourceSet, changeSerializer, issueAcceptor);
                        IRenameStrategy2 renameStrategy = (IRenameStrategy2)services.get(IRenameStrategy2.class);
                        renameStrategy.applyRename(renameContext);
                        ChangeConverter2.Factory converterFactory = (ChangeConverter2.Factory)services.get(ChangeConverter2.Factory.class);
                        ChangeConverter2 changeConverter = converterFactory.create(workspaceEdit, options.getLanguageServerAccess());
                        changeSerializer.applyModifications(changeConverter);
                    }
                } else {
                    issueAcceptor.add(RefactoringIssueAcceptor.Severity.FATAL, "Loaded resource is not an XtextResource", context.getResource().getURI());
                }
                issueAcceptor.checkSeverity();
                return workspaceEdit;
            };
            java.util.function.Function<Throwable, WorkspaceEdit> _function_1 = exception -> {
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    if (rootCause instanceof FileNotFoundException && shouldPrepareRename) {
                        return null;
                    }
                    throw exception;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            return (WorkspaceEdit)((CompletableFuture)options.getLanguageServerAccess().doRead(uri, _function).exceptionally((java.util.function.Function)_function_1)).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected EObject getElementAtOffset(XtextResource xtextResource, Document document, Position caretPosition) {
        EObject _elementWithIdentifierAt_1;
        int caretOffset = document.getOffSet(caretPosition);
        EObject _elvis = null;
        EObject _elementWithIdentifierAt = this.getElementWithIdentifierAt(xtextResource, caretOffset);
        _elvis = _elementWithIdentifierAt != null ? _elementWithIdentifierAt : (_elementWithIdentifierAt_1 = this.getElementWithIdentifierAt(xtextResource, caretOffset - 1));
        return _elvis;
    }

    protected EObject getElementWithIdentifierAt(XtextResource xtextResource, int offset) {
        if (offset >= 0) {
            ILeafNode leaf;
            ICompositeNode rootNode;
            IParseResult _parseResult = null;
            if (xtextResource != null) {
                _parseResult = xtextResource.getParseResult();
            }
            ICompositeNode _rootNode = null;
            if (_parseResult != null) {
                _rootNode = _parseResult.getRootNode();
            }
            if ((rootNode = _rootNode) != null && (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)offset)) != null && this.isIdentifier(leaf)) {
                return this.eObjectAtOffsetHelper.resolveElementAt(xtextResource, offset);
            }
        }
        return null;
    }

    protected boolean isIdentifier(ILeafNode leafNode) {
        return (leafNode.getGrammarElement() instanceof RuleCall || leafNode.getGrammarElement() instanceof CrossReference) && !this.tokenUtil.isWhitespaceOrCommentNode((INode)leafNode);
    }

    @Override
    public Either<Range, PrepareRenameResult> prepareRename(IRenameService2.PrepareRenameOptions options) {
        try {
            String uri = options.getParams().getTextDocument().getUri();
            boolean shouldPrepareRename = this.shouldPrepareRename(options.getLanguageServerAccess());
            java.util.function.Function<ILanguageServerAccess.Context, Either> _function = context -> {
                if (!shouldPrepareRename) {
                    return null;
                }
                Resource resource = context.getResource();
                Document document = context.getDocument();
                PrepareRenameParams params = options.getParams();
                CancelIndicator cancelIndicator = options.getCancelIndicator();
                return this.doPrepareRename(resource, document, params, cancelIndicator);
            };
            java.util.function.Function<Throwable, Either> _function_1 = exception -> {
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    if (rootCause instanceof FileNotFoundException && shouldPrepareRename) {
                        return null;
                    }
                    throw exception;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            return (Either)((CompletableFuture)options.getLanguageServerAccess().doRead(uri, _function).exceptionally((java.util.function.Function)_function_1)).get();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Either<Range, PrepareRenameResult> doPrepareRename(Resource resource, Document document, PrepareRenameParams params, CancelIndicator cancelIndicator) {
        String uri = params.getTextDocument().getUri();
        if (resource instanceof XtextResource) {
            ICompositeNode rootNode;
            IParseResult _parseResult = null;
            if ((XtextResource)resource != null) {
                _parseResult = ((XtextResource)resource).getParseResult();
            }
            ICompositeNode _rootNode = null;
            if (_parseResult != null) {
                _rootNode = _parseResult.getRootNode();
            }
            if ((rootNode = _rootNode) == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Could not retrieve root node for resource. URI: ");
                _builder.append(uri);
                _builder.append(".");
                LOG.trace((Object)_builder);
                return null;
            }
            Position caretPosition = params.getPosition();
            try {
                int caretOffset = document.getOffSet(caretPosition);
                EObject element = null;
                int candidateOffset = caretOffset;
                do {
                    ILeafNode leaf;
                    if ((element = this.getElementWithIdentifierAt((XtextResource)resource, candidateOffset)) == null || element.eIsProxy() || (leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)candidateOffset)) == null || !this.isIdentifier(leaf)) continue;
                    String leafText = NodeModelUtils.getTokenText((INode)leaf);
                    String elementName = this.getElementName(element);
                    if (StringExtensions.isNullOrEmpty((String)leafText) || StringExtensions.isNullOrEmpty((String)elementName) || !Objects.equal((Object)leafText, (Object)elementName)) continue;
                    Position start = document.getPosition(leaf.getOffset());
                    int _offset = leaf.getOffset();
                    int _length = elementName.length();
                    int _plus = _offset + _length;
                    Position end = document.getPosition(_plus);
                    Range _range = new Range(start, end);
                    return Either.forLeft((Object)_range);
                } while (--candidateOffset >= 0 && candidateOffset + 1 >= caretOffset);
            }
            catch (Throwable _t) {
                if (_t instanceof IndexOutOfBoundsException) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Invalid document ");
                    String _positionFragment = this.toPositionFragment(caretPosition, uri);
                    _builder_1.append(_positionFragment);
                    LOG.trace((Object)_builder_1);
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("No element found at ");
            String _positionFragment = this.toPositionFragment(caretPosition, uri);
            _builder_1.append(_positionFragment);
            LOG.trace((Object)_builder_1);
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Loaded resource is not an XtextResource. URI: ");
            URI _uRI = resource.getURI();
            _builder_2.append((Object)_uRI);
            LOG.trace((Object)_builder_2);
        }
        return null;
    }

    protected boolean mayPerformRename(Either<Range, PrepareRenameResult> prepareRenameResult, RenameParams renameParams) {
        return prepareRenameResult != null && prepareRenameResult.getLeft() != null && Ranges.containsPosition((Range)((Range)prepareRenameResult.getLeft()), (Position)renameParams.getPosition());
    }

    protected String getElementName(EObject element) {
        if (element == null) {
            return null;
        }
        String name = (String)this.attributeResolver.apply((Object)element);
        String _xifexpression = null;
        boolean _isEmpty = Strings.isEmpty((String)name);
        _xifexpression = _isEmpty ? null : name;
        return _xifexpression;
    }

    private String toPositionFragment(Position it, String uri) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("position line: ");
        int _line = it.getLine();
        _builder.append((Object)_line);
        _builder.append(" column: ");
        int _character = it.getCharacter();
        _builder.append((Object)_character);
        _builder.append(" in resource: ");
        _builder.append(uri);
        return _builder.toString();
    }

    private boolean shouldPrepareRename(ILanguageServerAccess access) {
        InitializeResult _initializeResult = null;
        if (access != null) {
            _initializeResult = access.getInitializeResult();
        }
        ServerCapabilities _capabilities = null;
        if (_initializeResult != null) {
            _capabilities = _initializeResult.getCapabilities();
        }
        Either _renameProvider = null;
        if (_capabilities != null) {
            _renameProvider = _capabilities.getRenameProvider();
        }
        Either provider = _renameProvider;
        boolean _xifexpression = false;
        if (provider != null && provider.isRight()) {
            Boolean _prepareProvider = ((RenameOptions)provider.getRight()).getPrepareProvider();
            _xifexpression = Objects.equal((Object)Boolean.TRUE, (Object)_prepareProvider);
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    @Pure
    protected EObjectAtOffsetHelper getEObjectAtOffsetHelper() {
        return this.eObjectAtOffsetHelper;
    }

    @Pure
    protected Provider<ServerRefactoringIssueAcceptor> getIssueProvider() {
        return this.issueProvider;
    }

    @Pure
    protected IResourceServiceProvider.Registry getServiceProviderRegistry() {
        return this.serviceProviderRegistry;
    }

    @Pure
    protected TokenUtil getTokenUtil() {
        return this.tokenUtil;
    }

    @Pure
    protected Function<EObject, String> getAttributeResolver() {
        return this.attributeResolver;
    }
}

