/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class ReadRequest<V>
extends AbstractRequest<V> {
    private static final Logger LOG = Logger.getLogger(ReadRequest.class);
    private final Functions.Function1<? super CancelIndicator, ? extends V> cancellable;
    private final ExecutorService executor;

    public ReadRequest(RequestManager requestManager, Functions.Function1<? super CancelIndicator, ? extends V> cancellable, ExecutorService executor) {
        super(requestManager);
        this.cancellable = cancellable;
        this.executor = executor;
    }

    @Override
    public void run() {
        if (this.result.isCancelled()) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.cancelIndicator.checkCanceled();
                this.result.complete(this.cancellable.apply((Object)this.cancelIndicator));
            }
            catch (Throwable t) {
                if (!this.requestManager.isCancelException(t)) {
                    LOG.error((Object)"Error during request: ", t);
                }
                this.result.completeExceptionally(t);
            }
        });
    }
}

