/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectDescriptionProvider;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.ide.serializer.impl.ChangeSerializer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Arrays;

public class EObjectDescriptionDeltaProvider {
    protected Delta createDelta(EObject object, IEObjectSnapshot snapshot, List<IEObjectDescription> descriptions) {
        return new Delta(object, snapshot, descriptions);
    }

    public Deltas getDelta(ChangeSerializer serializer, Collection<IResourceSnapshot> snapshots) {
        HashMap old = Maps.newHashMap();
        HashMap groups = Maps.newHashMap();
        for (IResourceSnapshot rs : snapshots) {
            old.putAll(rs.getObjects());
        }
        for (IResourceSnapshot rs : snapshots) {
            IEObjectDescriptionProvider p = serializer.getService(rs.getResource(), IEObjectDescriptionProvider.class);
            Iterable<IEObjectDescription> descriptions = p.getEObjectDescriptions(rs.getResource());
            for (IEObjectDescription desc : descriptions) {
                EObject obj = EcoreUtil.resolve((EObject)desc.getEObjectOrProxy(), (Resource)rs.getResource());
                Group delta = (Group)groups.get(obj);
                if (delta == null) {
                    delta = new Group(obj);
                    delta.snapshot = (IEObjectSnapshot)old.get(obj);
                    groups.put(obj, delta);
                }
                delta.descriptions.add(desc);
            }
        }
        Deltas result = new Deltas();
        result.snapshots = snapshots;
        for (Group g : groups.values()) {
            Delta delta = this.createDelta(g.object, g.snapshot, g.descriptions);
            if (!delta.hasQualifiedNameChanged() && !delta.hasSimpleNameOrUserdataChanged()) continue;
            result.deltas.put(delta.object, delta);
        }
        return result;
    }

    public static class Group {
        private List<IEObjectDescription> descriptions = Lists.newArrayList();
        private final EObject object;
        private IEObjectSnapshot snapshot;

        public Group(EObject object) {
            this.object = object;
        }
    }

    public static class Deltas {
        private final Map<EObject, Delta> deltas = Maps.newLinkedHashMap();
        private Collection<IResourceSnapshot> snapshots;

        public Delta getDelta(EObject obj) {
            return this.deltas.get(obj);
        }

        public Collection<IResourceSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }

    public static class Delta {
        private List<IEObjectDescription> descriptions = Lists.newArrayList();
        private final EObject object;
        private boolean qualifiedNameChanged;
        private boolean simpleNameAndUserDataChanged;
        private IEObjectSnapshot snapshot;

        public Delta(EObject object, IEObjectSnapshot snapshot, List<IEObjectDescription> descriptions) {
            this.object = object;
            this.snapshot = snapshot;
            this.descriptions = descriptions;
            this.simpleNameAndUserDataChanged = !this.forAll(this::isSimpleNameAndUserdataEqual);
            this.qualifiedNameChanged = !this.forAll(this::isQualifiedNameEqual);
        }

        protected boolean forAll(BiFunction<IEObjectDescription, IEObjectDescription, Boolean> comparator) {
            if (this.snapshot == null) {
                return false;
            }
            List<IEObjectDescription> snap = this.snapshot.getDescriptions();
            if (snap == null && this.descriptions == null) {
                return true;
            }
            if (snap == null || this.descriptions == null) {
                return false;
            }
            int size = this.descriptions.size();
            if (size == 0 && snap.isEmpty()) {
                return true;
            }
            if (size != snap.size()) {
                return false;
            }
            if (size == 1) {
                return comparator.apply(snap.get(0), this.descriptions.get(0));
            }
            HashSet candidates = Sets.newHashSet(snap);
            block0: for (IEObjectDescription d : this.descriptions) {
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    IEObjectDescription s = (IEObjectDescription)it.next();
                    if (!comparator.apply(d, s).booleanValue()) continue;
                    it.remove();
                    continue block0;
                }
                return false;
            }
            return true;
        }

        public List<IEObjectDescription> getDescriptions() {
            return this.descriptions;
        }

        public EObject getObject() {
            return this.object;
        }

        public IEObjectSnapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean hasQualifiedNameChanged() {
            return this.qualifiedNameChanged;
        }

        public boolean hasSimpleNameOrUserdataChanged() {
            return this.simpleNameAndUserDataChanged;
        }

        protected boolean isQualifiedNameEqual(IEObjectDescription desc1, IEObjectDescription desc2) {
            return desc1.getQualifiedName().equals((Object)desc2.getQualifiedName());
        }

        protected boolean isSimpleNameAndUserdataEqual(IEObjectDescription oldDesc, IEObjectDescription newDesc) {
            if (!oldDesc.getName().equals((Object)newDesc.getName())) {
                return false;
            }
            return this.isUserDataEqual(oldDesc, newDesc);
        }

        protected boolean isUserDataEqual(IEObjectDescription oldObj, IEObjectDescription newObj) {
            Object[] newKeys;
            String[] oldKeys = oldObj.getUserDataKeys();
            if (oldKeys.length != (newKeys = newObj.getUserDataKeys()).length) {
                return false;
            }
            for (String key : oldKeys) {
                String newValue;
                if (!Arrays.contains((Object[])newKeys, (Object)key)) {
                    return false;
                }
                String oldValue = oldObj.getUserData(key);
                if (Objects.equal((Object)oldValue, (Object)(newValue = newObj.getUserData(key)))) continue;
                return false;
            }
            return true;
        }
    }
}

