/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdater;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegion;

public class ReferenceUpdater
implements IReferenceUpdater {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IValueConverterService valueConverter;

    protected String findValidName(IUpdatableReference updatable, IScope scope) {
        Iterable elements = scope.getElements(updatable.getTargetEObject());
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)updatable.getCrossReference());
        for (IEObjectDescription desc : elements) {
            try {
                String unconverted = this.nameConverter.toString(desc.getName());
                String string = this.valueConverter.toString((Object)unconverted, ruleName);
                return string;
            }
            catch (ValueConverterException valueConverterException) {
            }
        }
        return null;
    }

    @Override
    public boolean isAffected(EObjectDescriptionDeltaProvider.Deltas deltas, RelatedResourcesProvider.RelatedResource resource) {
        for (IReferenceSnapshot ref : resource.outgoingReferences) {
            EObjectDescriptionDeltaProvider.Delta delta = deltas.findContainingDelta(ref.getTarget().getObject());
            if (delta == null) continue;
            return true;
        }
        return false;
    }

    protected boolean needsUpdating(EObjectDescriptionDeltaProvider.Deltas deltas, EObject source, EObject target) {
        EObjectDescriptionDeltaProvider.Delta targetDelta;
        EObjectDescriptionDeltaProvider.Delta sourceDelta = deltas.findContainingDelta(source);
        return !Objects.equal((Object)sourceDelta, (Object)(targetDelta = deltas.findContainingDelta(target)));
    }

    @Override
    public void update(IReferenceUpdaterContext context) {
        EObject root = (EObject)context.getResource().getContents().get(0);
        EObjectDescriptionDeltaProvider.Deltas deltas = context.getEObjectDescriptionDeltas();
        TreeIterator iterator = EcoreUtil2.eAll((EObject)root);
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            for (EReference ref : next.eClass().getEAllReferences()) {
                if (ref.isContainment()) continue;
                Object value = next.eGet((EStructuralFeature)ref);
                if (value instanceof List) {
                    List targets = (List)value;
                    for (int i = 0; i < targets.size(); ++i) {
                        EObject t = (EObject)targets.get(i);
                        if (!this.needsUpdating(deltas, next, t)) continue;
                        context.updateReference(next, ref, i);
                    }
                    continue;
                }
                if (!(value instanceof EObject) || !this.needsUpdating(deltas, next, (EObject)value)) continue;
                context.updateReference(next, ref);
            }
        }
    }

    @Override
    public void updateReference(ITextRegionDiffBuilder rewriter, IUpdatableReference upd) {
        ISemanticRegion region;
        QualifiedName oldName;
        IUpdatableReference updatable = upd;
        if (rewriter.isModified((ITextRegion)updatable.getReferenceRegion())) {
            return;
        }
        IScope scope = this.scopeProvider.getScope(updatable.getSourceEObject(), updatable.getEReference());
        IEObjectDescription oldDesc = scope.getSingleElement(oldName = this.nameConverter.toQualifiedName((region = updatable.getReferenceRegion()).getText()));
        if (oldDesc != null && oldDesc.getEObjectOrProxy() == updatable.getTargetEObject()) {
            return;
        }
        String newName = this.findValidName(updatable, scope);
        rewriter.replace(region, newName);
    }
}

