/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.ResourceModification;
import org.eclipse.xtext.ide.refactoring.ResourceURIChange;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class MoveResourceContext {
    private static final Logger LOG = Logger.getLogger(MoveResourceContext.class);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final List<ResourceURIChange> fileChanges;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final List<ResourceURIChange> folderChanges;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final RefactoringIssueAcceptor issueAcceptor;
    private final IChangeSerializer changeSerializer;
    private final ResourceSet resourceSet;
    private final Map<Resource, ResourceModification> modifications = CollectionLiterals.newHashMap();

    public ResourceModification addModification(URI uri, ResourceModification modification) {
        ResourceModification _xtrycatchfinallyexpression = null;
        try {
            ResourceModification _xblockexpression = null;
            Resource resource = this.resourceSet.getResource(uri, true);
            this.changeSerializer.beginRecordChanges(resource);
            _xtrycatchfinallyexpression = _xblockexpression = this.modifications.put(resource, modification);
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                Throwable t = _t;
                String _string = null;
                if (uri != null) {
                    _string = uri.toString();
                }
                String _plus = "Error loading resource " + _string;
                this.issueAcceptor.add(RefactoringIssueAcceptor.Severity.ERROR, _plus, t);
                LOG.error((Object)t);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public void executeModifications() {
        Consumer<Map.Entry> _function = it -> {
            try {
                ((ResourceModification)it.getValue()).modify((Resource)it.getKey());
            }
            catch (Throwable _t) {
                if (_t instanceof Throwable) {
                    Throwable t = _t;
                    Resource _key = (Resource)it.getKey();
                    URI _uRI = null;
                    if (_key != null) {
                        _uRI = _key.getURI();
                    }
                    String _string = null;
                    if (_uRI != null) {
                        _string = _uRI.toString();
                    }
                    String _plus = "Error executing modification on resource " + _string;
                    this.issueAcceptor.add(RefactoringIssueAcceptor.Severity.ERROR, _plus, t);
                    LOG.error((Object)t);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        this.modifications.entrySet().forEach(_function);
    }

    public MoveResourceContext(List<ResourceURIChange> fileChanges, List<ResourceURIChange> folderChanges, RefactoringIssueAcceptor issueAcceptor, IChangeSerializer changeSerializer, ResourceSet resourceSet) {
        this.fileChanges = fileChanges;
        this.folderChanges = folderChanges;
        this.issueAcceptor = issueAcceptor;
        this.changeSerializer = changeSerializer;
        this.resourceSet = resourceSet;
    }

    @Pure
    public List<ResourceURIChange> getFileChanges() {
        return this.fileChanges;
    }

    @Pure
    public List<ResourceURIChange> getFolderChanges() {
        return this.folderChanges;
    }

    @Pure
    public RefactoringIssueAcceptor getIssueAcceptor() {
        return this.issueAcceptor;
    }
}

