/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.xtext.ide.server.concurrent.Cancellable;
import org.eclipse.xtext.ide.server.concurrent.RequestCancelIndicator;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class RequestManager {
    private static final Logger LOGGER = Logger.getLogger(RequestManager.class);
    private final int MAX_PERMITS = Integer.MAX_VALUE;
    @Inject
    private ExecutorService executorService;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final LinkedBlockingQueue<Cancellable> cancelIndicators = new LinkedBlockingQueue();
    private final Semaphore semaphore = new Semaphore(this.MAX_PERMITS);

    public void shutdown() {
        this.executorService.shutdown();
    }

    public <V> CompletableFuture<V> runWrite(Functions.Function1<? super CancelIndicator, ? extends V> writeRequest) {
        try {
            this.semaphore.acquire(this.MAX_PERMITS);
            Function<CancelChecker, Object> _function = it -> {
                try {
                    RequestCancelIndicator cancelIndicator = new RequestCancelIndicator((CancelChecker)it);
                    this.cancelIndicators.add(cancelIndicator);
                    try {
                        CancelIndicator _function_1 = () -> {
                            cancelIndicator.checkCanceled();
                            return false;
                        };
                        Object object = writeRequest.apply((Object)_function_1);
                        return object;
                    }
                    catch (Throwable _t) {
                        if (!(_t instanceof Throwable)) throw Exceptions.sneakyThrow((Throwable)_t);
                        Throwable t = _t;
                        boolean _isCancelException = this.isCancelException(t);
                        if (!_isCancelException) throw t;
                        LOGGER.info((Object)"request cancelled.");
                        throw new CancellationException();
                    }
                    finally {
                        this.cancelIndicators.remove(cancelIndicator);
                        this.semaphore.release(this.MAX_PERMITS);
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            return CompletableFutures.computeAsync((Executor)this.executorService, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> readRequest) {
        try {
            this.semaphore.acquire(1);
            Function<CancelChecker, Object> _function = it -> {
                try {
                    RequestCancelIndicator cancelIndicator = new RequestCancelIndicator((CancelChecker)it);
                    this.cancelIndicators.add(cancelIndicator);
                    try {
                        CancelIndicator _function_1 = () -> {
                            cancelIndicator.checkCanceled();
                            return false;
                        };
                        Object object = readRequest.apply((Object)_function_1);
                        return object;
                    }
                    catch (Throwable _t) {
                        if (!(_t instanceof Throwable)) throw Exceptions.sneakyThrow((Throwable)_t);
                        Throwable t = _t;
                        boolean _isCancelException = this.isCancelException(t);
                        if (!_isCancelException) throw t;
                        LOGGER.info((Object)"request cancelled.");
                        throw new CancellationException();
                    }
                    finally {
                        this.cancelIndicators.remove(cancelIndicator);
                        this.semaphore.release(1);
                    }
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            return CompletableFutures.computeAsync((Executor)this.executorService, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isCancelException(Throwable t) {
        if (t == null) {
            return false;
        }
        Throwable _xifexpression = null;
        _xifexpression = t instanceof CompletionException ? ((CompletionException)t).getCause() : t;
        Throwable cause = _xifexpression;
        return this.operationCanceledManager.isOperationCanceledException(cause);
    }
}

