/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class IdeCrossrefProposalProvider {
    private static final Logger LOG = Logger.getLogger(IdeCrossrefProposalProvider.class);
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeContentProposalCreator proposalCreator;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    public void lookupCrossReference(IScope scope, CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        try {
            Iterable<IEObjectDescription> _queryScope = this.queryScope(scope, crossReference, context);
            for (IEObjectDescription candidate : _queryScope) {
                boolean _not;
                boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
                boolean bl = _not = !_canAcceptMoreProposals;
                if (_not) {
                    return;
                }
                boolean _apply = filter.apply((Object)candidate);
                if (!_apply) continue;
                ContentAssistEntry entry = this.createProposal(candidate, crossReference, context);
                int _crossRefPriority = this.proposalPriorities.getCrossRefPriority(candidate, entry);
                acceptor.accept(entry, _crossRefPriority);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof UnsupportedOperationException) {
                UnsupportedOperationException uoe = (UnsupportedOperationException)_t;
                LOG.error((Object)"Failed to create content assist proposals for cross-reference.", (Throwable)uoe);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope, CrossReference crossReference, ContentAssistContext context) {
        return scope.getAllElements();
    }

    protected ContentAssistEntry createProposal(IEObjectDescription candidate, CrossReference crossRef, ContentAssistContext context) {
        QualifiedName _name = candidate.getName();
        String _string = this.qualifiedNameConverter.toString(_name);
        Procedures.Procedure1 _function = it -> {
            it.setSource(candidate);
            EClass _eClass = candidate.getEClass();
            String _name_1 = null;
            if (_eClass != null) {
                _name_1 = _eClass.getName();
            }
            it.setDescription(_name_1);
        };
        return this.proposalCreator.createProposal(_string, context, (Procedures.Procedure1<? super ContentAssistEntry>)_function);
    }

    @Pure
    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    @Pure
    protected IdeContentProposalCreator getProposalCreator() {
        return this.proposalCreator;
    }
}

