/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FQNPrefixMatcher
implements IPrefixMatcher {
    @Inject
    @Accessors
    private IPrefixMatcher.IgnoreCase delegate;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    @Override
    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        boolean _isCandidateMatchingPrefix = this.delegate.isCandidateMatchingPrefix(name, prefix);
        if (_isCandidateMatchingPrefix) {
            return true;
        }
        String delimiter = this.getDelimiter();
        if (!StringExtensions.isNullOrEmpty((String)delimiter) && name.indexOf(delimiter) >= 0) {
            boolean _lessThan;
            int _indexOf = prefix.indexOf(delimiter);
            boolean bl = _lessThan = _indexOf < 0;
            if (_lessThan) {
                String lastSegment = this.getLastSegment(name, delimiter);
                if (lastSegment != null && this.delegate.isCandidateMatchingPrefix(lastSegment, prefix)) {
                    return true;
                }
            } else {
                int _size_1;
                boolean _lessThan_1;
                List splitPrefix = Strings.split((String)prefix, (String)delimiter);
                boolean _isEmpty = splitPrefix.isEmpty();
                if (_isEmpty) {
                    return false;
                }
                List splitName = Strings.split((String)name, (String)delimiter);
                int _size = splitName.size();
                boolean bl2 = _lessThan_1 = _size < (_size_1 = splitPrefix.size());
                if (_lessThan_1) {
                    return false;
                }
                for (int i = 0; i < splitPrefix.size(); ++i) {
                    boolean _not;
                    String _get_1;
                    String _get = (String)splitName.get(i);
                    boolean _isCandidateMatchingPrefix_1 = this.delegate.isCandidateMatchingPrefix(_get, _get_1 = (String)splitPrefix.get(i));
                    boolean bl3 = _not = !_isCandidateMatchingPrefix_1;
                    if (!_not) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected String getLastSegment(String fqn, String delimiter) {
        int lastDelimIndex = fqn.lastIndexOf(delimiter);
        if (lastDelimIndex >= 0 && lastDelimIndex + delimiter.length() < fqn.length()) {
            int _length = delimiter.length();
            int _plus = lastDelimIndex + _length;
            return fqn.substring(_plus);
        }
        return null;
    }

    public String getDelimiter() {
        if (this.qualifiedNameConverter instanceof IQualifiedNameConverter.DefaultImpl) {
            return ((IQualifiedNameConverter.DefaultImpl)this.qualifiedNameConverter).getDelimiter();
        }
        return ".";
    }

    @Pure
    public IPrefixMatcher.IgnoreCase getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IPrefixMatcher.IgnoreCase delegate) {
        this.delegate = delegate;
    }
}

