/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.hover;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Range;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class HoverService {
    @Inject
    @Extension
    private DocumentExtensions _documentExtensions;
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    @Extension
    private ILocationInFileProvider _iLocationInFileProvider;
    @Inject
    @Extension
    private IEObjectDocumentationProvider _iEObjectDocumentationProvider;

    public Hover hover(XtextResource resource, int offset) {
        boolean _not;
        Pair<EObject, ITextRegion> pair = this.getXtextElementAt(resource, offset);
        if (pair == null || pair.getFirst() == null || pair.getSecond() == null) {
            List _emptyList = Collections.emptyList();
            return new Hover(_emptyList, null);
        }
        EObject element = (EObject)pair.getFirst();
        List<? extends String> contents = this.getContents(element);
        if (contents == null) {
            List _emptyList_1 = Collections.emptyList();
            return new Hover(_emptyList_1, null);
        }
        ITextRegion textRegion = (ITextRegion)pair.getSecond();
        boolean _contains = textRegion.contains(offset);
        boolean bl = _not = !_contains;
        if (_not) {
            List _emptyList_2 = Collections.emptyList();
            return new Hover(_emptyList_2, null);
        }
        Range range = this._documentExtensions.newRange((Resource)resource, textRegion);
        Hover _hover = new Hover();
        Procedures.Procedure1 _function = b -> {
            b.setRange(range);
            Functions.Function1 _function_1 = it -> it;
            List _map = ListExtensions.map((List)contents, (Functions.Function1)_function_1);
            b.setContents(_map);
        };
        return (Hover)ObjectExtensions.operator_doubleArrow((Object)_hover, (Procedures.Procedure1)_function);
    }

    protected List<? extends String> getContents(EObject element) {
        List _xblockexpression = null;
        String documentation = this._iEObjectDocumentationProvider.getDocumentation(element);
        List _xifexpression = null;
        if (documentation == null) {
            return Collections.emptyList();
        }
        _xblockexpression = _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{documentation}));
        return _xblockexpression;
    }

    protected Pair<EObject, ITextRegion> getXtextElementAt(XtextResource resource, int offset) {
        EObject crossLinkedEObject = this._eObjectAtOffsetHelper.resolveCrossReferencedElementAt(resource, offset);
        if (crossLinkedEObject != null) {
            IParseResult parseResult;
            boolean _not;
            boolean _eIsProxy = crossLinkedEObject.eIsProxy();
            boolean bl = _not = !_eIsProxy;
            if (_not && (parseResult = resource.getParseResult()) != null) {
                ICompositeNode _rootNode = parseResult.getRootNode();
                ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)_rootNode, (int)offset);
                if (leafNode != null && leafNode.isHidden() && leafNode.getOffset() == offset) {
                    ILeafNode _findLeafNodeAtOffset;
                    ICompositeNode _rootNode_1 = parseResult.getRootNode();
                    leafNode = _findLeafNodeAtOffset = NodeModelUtils.findLeafNodeAtOffset((INode)_rootNode_1, (int)(offset - 1));
                }
                if (leafNode != null) {
                    ITextRegion leafRegion = leafNode.getTextRegion();
                    return Tuples.create((Object)crossLinkedEObject, (Object)leafRegion);
                }
            }
        } else {
            EObject o = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
            if (o != null) {
                ITextRegion region = this._iLocationInFileProvider.getSignificantTextRegion(o);
                return Tuples.create((Object)o, (Object)region);
            }
        }
        return null;
    }
}

