/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.IProjectDescriptionFactory;
import org.eclipse.xtext.ide.server.IWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class WorkspaceManager {
    @Inject
    private Provider<ProjectManager> projectManagerProvider;
    @Inject
    private IWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private IProjectDescriptionFactory projectDescriptionFactory;
    private BuildManager buildManager;
    private Map<String, ProjectManager> projectName2ProjectManager = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private URI baseDir;
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private IWorkspaceConfig workspaceConfig;
    private List<ILanguageServerAccess.IBuildListener> buildListeners = CollectionLiterals.newArrayList((Object[])new ILanguageServerAccess.IBuildListener[0]);
    private Map<String, ResourceDescriptionsData> fullIndex = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private Map<URI, Document> openDocuments = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            Document _get = (Document)WorkspaceManager.this.openDocuments.get(uri);
            String _contents = null;
            if (_get != null) {
                _contents = _get.getContents();
            }
            return _contents;
        }

        public boolean hasContent(URI uri) {
            return WorkspaceManager.this.openDocuments.containsKey(uri);
        }
    };
    private static final Logger LOG = Logger.getLogger(WorkspaceManager.class);

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    @Inject
    public void setBuildManager(BuildManager buildManager) {
        buildManager.setWorkspaceManager(this);
        this.buildManager = buildManager;
    }

    public void initialize(URI baseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor, CancelIndicator cancelIndicator) {
        this.baseDir = baseDir;
        this.issueAcceptor = issueAcceptor;
        this.refreshWorkspaceConfig(cancelIndicator);
    }

    protected void refreshWorkspaceConfig(CancelIndicator cancelIndicator) {
        IWorkspaceConfig _workspaceConfig;
        this.workspaceConfig = _workspaceConfig = this.workspaceConfigFactory.getWorkspaceConfig(this.baseDir);
        ArrayList newProjects = CollectionLiterals.newArrayList((Object[])new ProjectDescription[0]);
        Set<String> _keySet = this.projectName2ProjectManager.keySet();
        HashSet remainingProjectNames = CollectionLiterals.newHashSet((Object[])new Set[]{_keySet});
        Set _projects = this.workspaceConfig.getProjects();
        Consumer<IProjectConfig> _function = projectConfig -> {
            String _name = projectConfig.getName();
            boolean _containsKey = this.projectName2ProjectManager.containsKey(_name);
            if (_containsKey) {
                String _name_1 = projectConfig.getName();
                remainingProjectNames.remove(_name_1);
            } else {
                ProjectManager projectManager = (ProjectManager)this.projectManagerProvider.get();
                ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription((IProjectConfig)projectConfig);
                Provider _function_1 = () -> this.fullIndex;
                projectManager.initialize(projectDescription, (IProjectConfig)projectConfig, this.issueAcceptor, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)_function_1, cancelIndicator);
                String _name_2 = projectDescription.getName();
                this.projectName2ProjectManager.put(_name_2, projectManager);
                newProjects.add(projectDescription);
            }
        };
        _projects.forEach(_function);
        for (Set deletedProject : remainingProjectNames) {
            this.projectName2ProjectManager.remove(deletedProject);
            this.fullIndex.remove(deletedProject);
        }
        List<IResourceDescription.Delta> result = this.buildManager.doInitialBuild(newProjects, cancelIndicator);
        this.afterBuild(result);
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        List<IResourceDescription.Delta> doBuild = this.buildManager.doBuild(dirtyFiles, deletedFiles, cancelIndicator);
        this.afterBuild(doBuild);
        return doBuild;
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    public URI getProjectBaseDir(URI candidate) {
        URI _xblockexpression = null;
        IProjectConfig projectConfig = this.workspaceConfig.findProjectContaining(candidate);
        _xblockexpression = projectConfig.getPath();
        return _xblockexpression;
    }

    public ProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.workspaceConfig.findProjectContaining(uri);
        String _name = projectConfig.getName();
        return this.projectName2ProjectManager.get(_name);
    }

    public ProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public List<ProjectManager> getProjectManagers() {
        Collection<ProjectManager> _values = this.projectName2ProjectManager.values();
        return new ArrayList<ProjectManager>(_values);
    }

    public void didChange(URI uri, int version, Iterable<TextEdit> changes, CancelIndicator cancelIndicator) {
        boolean _not;
        boolean _containsKey = this.openDocuments.containsKey(uri);
        boolean bl = _not = !_containsKey;
        if (_not) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return;
        }
        Document contents = this.openDocuments.get(uri);
        Document _applyChanges = contents.applyChanges(changes);
        this.openDocuments.put(uri, _applyChanges);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new URI[0]);
        this.doBuild(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), _newArrayList, cancelIndicator);
    }

    public List<IResourceDescription.Delta> didOpen(URI uri, int version, String contents, CancelIndicator cancelIndicator) {
        List<IResourceDescription.Delta> _xblockexpression = null;
        Document _document = new Document(version, contents);
        this.openDocuments.put(uri, _document);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new URI[0]);
        _xblockexpression = this.doBuild(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), _newArrayList, cancelIndicator);
        return _xblockexpression;
    }

    public List<IResourceDescription.Delta> didClose(URI uri, CancelIndicator cancelIndicator) {
        List<IResourceDescription.Delta> _xblockexpression = null;
        this.openDocuments.remove(uri);
        List<IResourceDescription.Delta> _xifexpression = null;
        boolean _exists = this.exists(uri);
        if (_exists) {
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new URI[0]);
            _xifexpression = this.doBuild(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), _newArrayList, cancelIndicator);
        } else {
            ArrayList _newArrayList_1 = CollectionLiterals.newArrayList((Object[])new URI[0]);
            _xifexpression = this.doBuild(_newArrayList_1, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new URI[]{uri})), cancelIndicator);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected boolean exists(URI uri) {
        ProjectManager _projectManager = this.getProjectManager(uri);
        XtextResourceSet _resourceSet = _projectManager.getResourceSet();
        URIConverter _uRIConverter = _resourceSet.getURIConverter();
        return _uRIConverter.exists(uri, null);
    }

    public <T> T doRead(URI uri, Functions.Function2<? super Document, ? super XtextResource, ? extends T> work) {
        URI resourceURI = uri.trimFragment();
        ProjectManager projectMnr = this.getProjectManager(resourceURI);
        Resource _resource = projectMnr.getResource(resourceURI);
        XtextResource resource = (XtextResource)_resource;
        Document doc = this.getDocument(resource);
        Resource _resource_1 = projectMnr.getResource(resourceURI);
        return (T)work.apply((Object)doc, (Object)((XtextResource)_resource_1));
    }

    protected Document getDocument(XtextResource resource) {
        Document _elvis = null;
        URI _uRI = resource.getURI();
        Document _get = this.openDocuments.get(_uRI);
        if (_get != null) {
            _elvis = _get;
        } else {
            Document _document;
            IParseResult _parseResult = resource.getParseResult();
            ICompositeNode _rootNode = _parseResult.getRootNode();
            String _text = _rootNode.getText();
            _elvis = _document = new Document(1, _text);
        }
        return _elvis;
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }
}

