/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class ProjectManager {
    @Inject
    protected IncrementalBuilder incrementalBuilder;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    protected IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IExternalContentSupport externalContentSupport;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IndexState indexState = new IndexState();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private URI baseDir;
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private Provider<Map<String, ResourceDescriptionsData>> indexProvider;
    private IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextResourceSet resourceSet;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private ProjectDescription projectDescription;
    private IProjectConfig projectConfig;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> acceptor, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider, CancelIndicator cancelIndicator) {
        URI _path;
        this.projectDescription = description;
        this.projectConfig = projectConfig;
        this.baseDir = _path = projectConfig.getPath();
        this.issueAcceptor = acceptor;
        this.openedDocumentsContentProvider = openedDocumentsContentProvider;
        this.indexProvider = indexProvider;
    }

    public IncrementalBuilder.Result doInitialBuild(CancelIndicator cancelIndicator) {
        ArrayList uris = CollectionLiterals.newArrayList((Object[])new URI[0]);
        Set _sourceFolders = this.projectConfig.getSourceFolders();
        Consumer<ISourceFolder> _function = it -> {
            URI _path = it.getPath();
            IAcceptor _function_1 = it_1 -> uris.add(it_1);
            this.fileSystemScanner.scan(_path, _function_1);
        };
        _sourceFolders.forEach(_function);
        List _emptyList = CollectionLiterals.emptyList();
        return this.doBuild(uris, _emptyList, cancelIndicator);
    }

    public IncrementalBuilder.Result doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        XtextResourceSet _resourceSet;
        IndexState _indexState;
        BuildRequest request = this.newBuildRequest(dirtyFiles, deletedFiles, cancelIndicator);
        Functions.Function1 _function = it -> this.languagesRegistry.getResourceServiceProvider(it);
        IncrementalBuilder.Result result = this.incrementalBuilder.build(request, _function);
        this.indexState = _indexState = result.getIndexState();
        this.resourceSet = _resourceSet = request.getResourceSet();
        Map _get = (Map)this.indexProvider.get();
        String _name = this.projectDescription.getName();
        ResourceDescriptionsData _resourceDescriptions = this.indexState.getResourceDescriptions();
        _get.put(_name, _resourceDescriptions);
        return result;
    }

    protected BuildRequest newBuildRequest(List<URI> changedFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        BuildRequest _buildRequest = new BuildRequest();
        Procedures.Procedure1 _function = it -> {
            it.setBaseDir(this.baseDir);
            ResourceDescriptionsData _resourceDescriptions = this.indexState.getResourceDescriptions();
            ResourceDescriptionsData _copy = _resourceDescriptions.copy();
            Source2GeneratedMapping _fileMappings = this.indexState.getFileMappings();
            Source2GeneratedMapping _copy_1 = _fileMappings.copy();
            IndexState _indexState = new IndexState(_copy, _copy_1);
            it.setState(_indexState);
            IndexState _state = it.getState();
            ResourceDescriptionsData _resourceDescriptions_1 = _state.getResourceDescriptions();
            XtextResourceSet _createFreshResourceSet = this.createFreshResourceSet(_resourceDescriptions_1);
            it.setResourceSet(_createFreshResourceSet);
            it.setDirtyFiles(changedFiles);
            it.setDeletedFiles(deletedFiles);
            BuildRequest.IPostValidationCallback _function_1 = (uri, issues) -> {
                this.issueAcceptor.apply((Object)uri, (Object)issues);
                return true;
            };
            it.setAfterValidate(_function_1);
            it.setCancelIndicator(cancelIndicator);
        };
        return (BuildRequest)ObjectExtensions.operator_doubleArrow((Object)_buildRequest, (Procedures.Procedure1)_function);
    }

    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet _get = (XtextResourceSet)this.resourceSetProvider.get();
        Procedures.Procedure1 _function = it -> {
            this.projectDescription.attachToEmfObject((Notifier)it);
            ProjectConfigAdapter.install((ResourceSet)it, (IProjectConfig)this.projectConfig);
            Map _get_1 = (Map)this.indexProvider.get();
            ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(_get_1, (ResourceSet)it);
            String _name = this.projectDescription.getName();
            index.setContainer(_name, newIndex);
            this.externalContentSupport.configureResourceSet((ResourceSet)it, this.openedDocumentsContentProvider);
        };
        return (XtextResourceSet)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    public Resource getResource(URI uri) {
        return this.resourceSet.getResource(uri, true);
    }

    public void reportProjectIssue(String message, String code, Severity severity) {
        Issue.IssueImpl _issueImpl = new Issue.IssueImpl();
        Procedures.Procedure1 _function = it -> {
            it.setMessage(message);
            it.setCode(code);
            it.setSeverity(severity);
            it.setUriToProblem(this.baseDir);
        };
        Issue.IssueImpl _doubleArrow = (Issue.IssueImpl)ObjectExtensions.operator_doubleArrow((Object)_issueImpl, (Procedures.Procedure1)_function);
        this.issueAcceptor.apply((Object)this.baseDir, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Issue[]{_doubleArrow})));
    }

    @Pure
    public IndexState getIndexState() {
        return this.indexState;
    }

    @Pure
    public URI getBaseDir() {
        return this.baseDir;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public ProjectDescription getProjectDescription() {
        return this.projectDescription;
    }
}

