/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColoringInformation;
import org.eclipse.lsp4j.ColoringParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageClientExtensions;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.ILanguageServerExtension;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.ide.server.coloring.IColoringService;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.ide.server.contentassist.ContentAssistService;
import org.eclipse.xtext.ide.server.findReferences.WorkspaceResourceAccess;
import org.eclipse.xtext.ide.server.formatting.FormattingService;
import org.eclipse.xtext.ide.server.hover.HoverService;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.signatureHelp.ISignatureHelpService;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.WorkspaceSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class LanguageServerImpl
implements LanguageServer,
WorkspaceService,
TextDocumentService,
LanguageClientAware,
Endpoint,
JsonRpcMethodProvider,
ILanguageServerAccess.IBuildListener {
    @Inject
    private RequestManager requestManager;
    @Inject
    private WorkspaceSymbolService workspaceSymbolService;
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    @Extension
    private IResourceServiceProvider.Registry languagesRegistry;
    private WorkspaceManager workspaceManager;
    private InitializeParams params;
    private WorkspaceResourceAccess resourceAccess;
    private LanguageClient client;
    private Map<String, JsonRpcMethod> supportedMethods = null;
    private Multimap<String, Endpoint> extensionProviders = LinkedListMultimap.create();
    private ILanguageServerAccess access = new ILanguageServerAccess(){

        @Override
        public <T> CompletableFuture<T> doRead(String uri, Function<ILanguageServerAccess.Context, T> function) {
            Functions.Function1 _function = cancelIndicator -> {
                URI _uri = LanguageServerImpl.this._uriExtensions.toUri(uri);
                Functions.Function2 _function_1 = (document, resource) -> {
                    URI _uRI = resource.getURI();
                    boolean _isDocumentOpen = LanguageServerImpl.this.workspaceManager.isDocumentOpen(_uRI);
                    ILanguageServerAccess.Context ctx = new ILanguageServerAccess.Context((Resource)resource, (Document)document, _isDocumentOpen, (CancelIndicator)cancelIndicator);
                    return function.apply(ctx);
                };
                return LanguageServerImpl.this.workspaceManager.doRead(_uri, _function_1);
            };
            return LanguageServerImpl.this.requestManager.runRead(_function);
        }

        @Override
        public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
            LanguageServerImpl.this.workspaceManager.addBuildListener(listener);
        }

        @Override
        public LanguageClient getLanguageClient() {
            return LanguageServerImpl.this.client;
        }
    };
    private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class);

    @Inject
    public void setWorkspaceManager(WorkspaceManager manager) {
        WorkspaceResourceAccess _workspaceResourceAccess;
        this.workspaceManager = manager;
        this.resourceAccess = _workspaceResourceAccess = new WorkspaceResourceAccess(this.workspaceManager);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        boolean _tripleEquals;
        if (this.params != null) {
            throw new IllegalStateException("This language server has already been initialized.");
        }
        String _rootPath = params.getRootPath();
        boolean bl = _tripleEquals = _rootPath == null;
        if (_tripleEquals) {
            throw new IllegalArgumentException("Bad initialization request. rootPath must not be null.");
        }
        Map _extensionToFactoryMap = this.languagesRegistry.getExtensionToFactoryMap();
        boolean _isEmpty = _extensionToFactoryMap.isEmpty();
        if (_isEmpty) {
            throw new IllegalStateException("No Xtext languages have been registered. Please make sure you have added the languages's setup class in '/META-INF/services/org.eclipse.xtext.ISetup'");
        }
        this.params = params;
        InitializeResult result = new InitializeResult();
        ServerCapabilities _serverCapabilities = new ServerCapabilities();
        Procedures.Procedure1 _function = it -> {
            it.setHoverProvider(Boolean.valueOf(true));
            it.setDefinitionProvider(Boolean.valueOf(true));
            it.setReferencesProvider(Boolean.valueOf(true));
            it.setDocumentSymbolProvider(Boolean.valueOf(true));
            it.setWorkspaceSymbolProvider(Boolean.valueOf(true));
            SignatureHelpOptions _signatureHelpOptions = new SignatureHelpOptions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"(", ","})));
            it.setSignatureHelpProvider(_signatureHelpOptions);
            it.setTextDocumentSync(TextDocumentSyncKind.Incremental);
            CompletionOptions _completionOptions = new CompletionOptions();
            Procedures.Procedure1 _function_1 = it_1 -> {
                it_1.setResolveProvider(Boolean.valueOf(false));
                it_1.setTriggerCharacters(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"."})));
            };
            CompletionOptions _doubleArrow = (CompletionOptions)ObjectExtensions.operator_doubleArrow((Object)_completionOptions, (Procedures.Procedure1)_function_1);
            it.setCompletionProvider(_doubleArrow);
            it.setDocumentFormattingProvider(Boolean.valueOf(true));
            it.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
            it.setDocumentHighlightProvider(Boolean.valueOf(true));
        };
        ServerCapabilities _doubleArrow = (ServerCapabilities)ObjectExtensions.operator_doubleArrow((Object)_serverCapabilities, (Procedures.Procedure1)_function);
        result.setCapabilities(_doubleArrow);
        Functions.Function1 _function_1 = cancelIndicator -> {
            String _rootPath_1 = params.getRootPath();
            URI _createFileURI = URI.createFileURI((String)_rootPath_1);
            String _path = this._uriExtensions.toPath(_createFileURI);
            URI rootURI = this._uriExtensions.toUri(_path);
            Procedures.Procedure2 _function_2 = ($0, $1) -> this.publishDiagnostics((URI)$0, (Iterable<? extends Issue>)$1);
            this.workspaceManager.initialize(rootURI, (Procedures.Procedure2<? super URI, ? super Iterable<Issue>>)_function_2, (CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function_1);
        this.access.addBuildListener(this);
        return CompletableFuture.completedFuture(result);
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(null);
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            TextDocumentItem _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI _uri_1 = this._uriExtensions.toUri(_uri);
            TextDocumentItem _textDocument_1 = params.getTextDocument();
            int _version = _textDocument_1.getVersion();
            TextDocumentItem _textDocument_2 = params.getTextDocument();
            String _text = _textDocument_2.getText();
            this.workspaceManager.didOpen(_uri_1, _version, _text, (CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            VersionedTextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI _uri_1 = this._uriExtensions.toUri(_uri);
            VersionedTextDocumentIdentifier _textDocument_1 = params.getTextDocument();
            int _version = _textDocument_1.getVersion();
            List _contentChanges = params.getContentChanges();
            Functions.Function1 _function_1 = event -> {
                Range _range = event.getRange();
                String _text = event.getText();
                return new TextEdit(_range, _text);
            };
            List _map = ListExtensions.map((List)_contentChanges, (Functions.Function1)_function_1);
            this.workspaceManager.didChange(_uri_1, _version, _map, (CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI _uri_1 = this._uriExtensions.toUri(_uri);
            this.workspaceManager.didClose(_uri_1, (CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function);
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ArrayList dirtyFiles = CollectionLiterals.newArrayList((Object[])new URI[0]);
            ArrayList deletedFiles = CollectionLiterals.newArrayList((Object[])new URI[0]);
            List _changes = params.getChanges();
            for (FileEvent fileEvent : _changes) {
                boolean _tripleEquals;
                FileChangeType _type = fileEvent.getType();
                boolean bl = _tripleEquals = _type == FileChangeType.Deleted;
                if (_tripleEquals) {
                    String _uri = fileEvent.getUri();
                    URI _uri_1 = this._uriExtensions.toUri(_uri);
                    deletedFiles.add(_uri_1);
                    continue;
                }
                String _uri_2 = fileEvent.getUri();
                URI _uri_3 = this._uriExtensions.toUri(_uri_2);
                dirtyFiles.add(_uri_3);
            }
            this.workspaceManager.doBuild(dirtyFiles, deletedFiles, (CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            this.workspaceManager.refreshWorkspaceConfig((CancelIndicator)cancelIndicator);
            return null;
        };
        this.requestManager.runWrite(_function);
    }

    private void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        PublishDiagnosticsParams _publishDiagnosticsParams = new PublishDiagnosticsParams();
        Procedures.Procedure1 _function = it -> {
            String _path = this._uriExtensions.toPath(uri);
            it.setUri(_path);
            Functions.Function1 _function_1 = it_1 -> this.toDiagnostic((Issue)it_1);
            Iterable _map = IterableExtensions.map((Iterable)issues, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_map);
            it.setDiagnostics(_list);
        };
        PublishDiagnosticsParams diagnostics = (PublishDiagnosticsParams)ObjectExtensions.operator_doubleArrow((Object)_publishDiagnosticsParams, (Procedures.Procedure1)_function);
        this.client.publishDiagnostics(diagnostics);
    }

    private Diagnostic toDiagnostic(Issue issue) {
        Diagnostic _diagnostic = new Diagnostic();
        Procedures.Procedure1 _function = it -> {
            String _code = issue.getCode();
            it.setCode(_code);
            DiagnosticSeverity _switchResult = null;
            Severity _severity = issue.getSeverity();
            if (_severity != null) {
                switch (_severity) {
                    case ERROR: {
                        _switchResult = DiagnosticSeverity.Error;
                        break;
                    }
                    case WARNING: {
                        _switchResult = DiagnosticSeverity.Warning;
                        break;
                    }
                    case INFO: {
                        _switchResult = DiagnosticSeverity.Information;
                        break;
                    }
                    default: {
                        _switchResult = DiagnosticSeverity.Hint;
                        break;
                    }
                }
            } else {
                _switchResult = DiagnosticSeverity.Hint;
            }
            it.setSeverity(_switchResult);
            String _message = issue.getMessage();
            it.setMessage(_message);
            Integer _elvis = null;
            Integer _lineNumber = issue.getLineNumber();
            _elvis = _lineNumber != null ? _lineNumber : Integer.valueOf(1);
            int lineNumber = _elvis - 1;
            Integer _elvis_1 = null;
            Integer _column = issue.getColumn();
            _elvis_1 = _column != null ? _column : Integer.valueOf(1);
            int column = _elvis_1 - 1;
            Integer _elvis_2 = null;
            Integer _length = issue.getLength();
            _elvis_2 = _length != null ? _length : Integer.valueOf(0);
            Integer length = _elvis_2;
            Position _position = new Position(lineNumber, column);
            Position _position_1 = new Position(lineNumber, column + length);
            Range _range = new Range(_position, _position_1);
            it.setRange(_range);
        };
        return (Diagnostic)ObjectExtensions.operator_doubleArrow((Object)_diagnostic, (Procedures.Procedure1)_function);
    }

    public CompletableFuture<CompletionList> completion(TextDocumentPositionParams params) {
        Functions.Function1 _function = origialCancelIndicator -> {
            ContentAssistService contentAssistService;
            BufferedCancelIndicator cancelIndicator = new BufferedCancelIndicator((CancelIndicator)origialCancelIndicator);
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ContentAssistService _get = null;
            if (resourceServiceProvider != null) {
                _get = (ContentAssistService)resourceServiceProvider.get(ContentAssistService.class);
            }
            if ((contentAssistService = _get) == null) {
                return new CompletionList();
            }
            Functions.Function2 _function_1 = (document, resource) -> contentAssistService.createCompletionList((Document)document, (XtextResource)resource, params, cancelIndicator);
            CompletionList result = (CompletionList)this.workspaceManager.doRead(uri, _function_1);
            return result;
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                Position _position = params.getPosition();
                int offset = document.getOffSet(_position);
                return documentSymbolService.getDefinitions((XtextResource)resource, offset, this.resourceAccess, (CancelIndicator)cancelIndicator);
            };
            List definitions = (List)this.workspaceManager.doRead(uri, _function_1);
            return definitions;
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                Position _position = params.getPosition();
                int offset = document.getOffSet(_position);
                List<? extends Location> _xifexpression = null;
                ReferenceContext _context = params.getContext();
                boolean _isIncludeDeclaration = _context.isIncludeDeclaration();
                _xifexpression = _isIncludeDeclaration ? documentSymbolService.getDefinitions((XtextResource)resource, offset, this.resourceAccess, (CancelIndicator)cancelIndicator) : CollectionLiterals.emptyList();
                List<? extends Location> definitions = _xifexpression;
                IResourceDescriptions indexData = this.workspaceManager.getIndex();
                List<? extends Location> references = documentSymbolService.getReferences((XtextResource)resource, offset, this.resourceAccess, indexData, (CancelIndicator)cancelIndicator);
                Iterable result = Iterables.concat(definitions, references);
                return IterableExtensions.toList((Iterable)result);
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> documentSymbolService.getSymbols((XtextResource)resource, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IResourceDescriptions indexData = this.workspaceManager.getIndex();
            String _query = params.getQuery();
            return this.workspaceSymbolService.getSymbols(_query, this.resourceAccess, indexData, (CancelIndicator)cancelIndicator);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            HoverService hoverService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            HoverService _get = null;
            if (resourceServiceProvider != null) {
                _get = (HoverService)resourceServiceProvider.get(HoverService.class);
            }
            if ((hoverService = _get) == null) {
                List _emptyList = CollectionLiterals.emptyList();
                return new Hover(_emptyList, null);
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                Position _position = params.getPosition();
                int offset = document.getOffSet(_position);
                return hoverService.hover((XtextResource)resource, offset);
            };
            return (Hover)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams position) {
        Functions.Function1 _function = cancelIndicator -> {
            ISignatureHelpService helper;
            TextDocumentIdentifier _textDocument = position.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ISignatureHelpService _get = null;
            if (serviceProvider != null) {
                _get = (ISignatureHelpService)serviceProvider.get(ISignatureHelpService.class);
            }
            if ((helper = _get) == null) {
                return new SignatureHelp();
            }
            Functions.Function2 _function_1 = (doc, resource) -> {
                Position _position = position.getPosition();
                int offset = doc.getOffSet(_position);
                return helper.getSignatureHelp((XtextResource)resource, offset);
            };
            return (SignatureHelp)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams position) {
        Functions.Function1 _function = cancelIndicator -> {
            IDocumentHighlightService service;
            TextDocumentIdentifier _textDocument = position.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IDocumentHighlightService _get = null;
            if (serviceProvider != null) {
                _get = (IDocumentHighlightService)serviceProvider.get(IDocumentHighlightService.class);
            }
            if ((service = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (doc, resource) -> {
                Position _position = position.getPosition();
                int offset = doc.getOffSet(_position);
                return service.getDocumentHighlights((XtextResource)resource, offset);
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends Command>> codeAction(CodeActionParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return Collections.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                boolean offset = false;
                String _contents = document.getContents();
                int length = _contents.length();
                if (length == 0 || resource.getContents().isEmpty()) {
                    return CollectionLiterals.emptyList();
                }
                return formatterService.format((XtextResource)resource, (Document)document, 0, length);
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            TextDocumentIdentifier _textDocument = params.getTextDocument();
            String _uri = _textDocument.getUri();
            URI uri = this._uriExtensions.toUri(_uri);
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return Collections.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                Range _range = params.getRange();
                Position _start = _range.getStart();
                int offset = document.getOffSet(_start);
                Range _range_1 = params.getRange();
                Position _end = _range_1.getEnd();
                int _offSet = document.getOffSet(_end);
                int length = _offSet - offset;
                return formatterService.format((XtextResource)resource, (Document)document, offset, length);
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public void notify(String method, Object parameter) {
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                endpoint.notify(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        boolean _not;
        boolean _containsKey = this.extensionProviders.containsKey((Object)method);
        boolean bl = _not = !_containsKey;
        if (_not) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                return endpoint.request(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionProviders;
        synchronized (multimap) {
            LinkedHashMap supportedMethods = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
            Class<?> _class = this.getClass();
            Map _supportedMethods = ServiceEndpoints.getSupportedMethods(_class);
            supportedMethods.putAll(_supportedMethods);
            LinkedHashMap extensions = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
            Map _extensionToFactoryMap = this.languagesRegistry.getExtensionToFactoryMap();
            Collection _values = _extensionToFactoryMap.values();
            Set _set = IterableExtensions.toSet(_values);
            Iterable _filter = Iterables.filter((Iterable)_set, IResourceServiceProvider.class);
            for (IResourceServiceProvider resourceServiceProvider : _filter) {
                ILanguageServerExtension ext = (ILanguageServerExtension)resourceServiceProvider.get(ILanguageServerExtension.class);
                if (ext == null) continue;
                ext.initialize(this.access);
                Map _xifexpression = null;
                if (ext instanceof JsonRpcMethodProvider) {
                    _xifexpression = ((JsonRpcMethodProvider)ext).supportedMethods();
                } else {
                    Class<?> _class_1 = ext.getClass();
                    _xifexpression = ServiceEndpoints.getSupportedMethods(_class_1);
                }
                Map supportedExtensions = _xifexpression;
                Set _entrySet = supportedExtensions.entrySet();
                for (Map.Entry entry : _entrySet) {
                    JsonRpcMethod _value;
                    String _key = (String)entry.getKey();
                    boolean _containsKey = supportedMethods.containsKey(_key);
                    if (_containsKey) {
                        String _key_1 = (String)entry.getKey();
                        String _plus = "The json rpc method '" + _key_1;
                        String _plus_1 = _plus + "' can not be an extension as it is already defined in the LSP standard.";
                        LOG.error((Object)_plus_1);
                        continue;
                    }
                    String _key_2 = (String)entry.getKey();
                    JsonRpcMethod existing = extensions.put(_key_2, _value = (JsonRpcMethod)entry.getValue());
                    if (existing != null && !Objects.equal((Object)existing, entry.getValue())) {
                        String _key_3 = (String)entry.getKey();
                        String _plus_2 = "An incompatible LSP extension '" + _key_3;
                        String _plus_3 = _plus_2 + "' has already been registered. Using 1 ignoring 2. \n1 : ";
                        String _plus_4 = _plus_3 + existing;
                        String _plus_5 = _plus_4 + " \n2 : ";
                        JsonRpcMethod _value_1 = (JsonRpcMethod)entry.getValue();
                        String _plus_6 = _plus_5 + _value_1;
                        LOG.error((Object)_plus_6);
                        String _key_4 = (String)entry.getKey();
                        extensions.put(_key_4, existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    String _key_5 = (String)entry.getKey();
                    this.extensionProviders.put((Object)_key_5, (Object)endpoint);
                    String _key_6 = (String)entry.getKey();
                    JsonRpcMethod _value_2 = (JsonRpcMethod)entry.getValue();
                    supportedMethods.put(_key_6, _value_2);
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    @Override
    public void afterBuild(List<IResourceDescription.Delta> deltas) {
        if (this.client instanceof LanguageClientExtensions) {
            Functions.Function1 _function = it -> {
                IResourceDescription _new = it.getNew();
                return _new != null;
            };
            Iterable _filter = IterableExtensions.filter(deltas, (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> {
                URI _uri = it.getUri();
                return _uri.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
            Consumer<String> _function_2 = it -> {
                Function<ILanguageServerAccess.Context, Void> _function_3 = ctx -> {
                    boolean _isDocumentOpen = ctx.isDocumentOpen();
                    if (_isDocumentOpen) {
                        Resource _resource = ctx.getResource();
                        if (_resource instanceof XtextResource) {
                            IColoringService coloringService;
                            Resource _resource_1 = ctx.getResource();
                            XtextResource resource = (XtextResource)_resource_1;
                            URI _uRI = resource.getURI();
                            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(_uRI);
                            IColoringService _get = null;
                            if (serviceProvider != null) {
                                _get = (IColoringService)serviceProvider.get(IColoringService.class);
                            }
                            if ((coloringService = _get) != null) {
                                boolean _not;
                                Document doc = ctx.getDocument();
                                List<? extends ColoringInformation> coloringInfos = coloringService.getColoring(resource, doc);
                                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(coloringInfos);
                                boolean bl = _not = !_isNullOrEmpty;
                                if (_not) {
                                    URI _uRI_1 = resource.getURI();
                                    String uri = _uRI_1.toString();
                                    ColoringParams _coloringParams = new ColoringParams(uri, coloringInfos);
                                    ((LanguageClientExtensions)this.client).updateColoring(_coloringParams);
                                }
                            }
                        }
                        return null;
                    }
                    return null;
                };
                this.access.doRead((String)it, _function_3);
            };
            _map.forEach(_function_2);
        }
    }

    @FinalFieldsConstructor
    public static class BufferedCancelIndicator
    implements CancelIndicator {
        private final CancelIndicator delegate;
        private Long canceledSince;

        public boolean isCanceled() {
            if (this.canceledSince == null && this.delegate.isCanceled()) {
                long _currentTimeMillis = System.currentTimeMillis();
                this.canceledSince = _currentTimeMillis;
                return false;
            }
            return this.canceledSince != null && System.currentTimeMillis() > this.canceledSince + 1000L;
        }

        public BufferedCancelIndicator(CancelIndicator delegate) {
            this.delegate = delegate;
        }
    }
}

