/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.build.IncrementalBuilder;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.TopologicalSorter;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class BuildManager {
    public static final String CYCLIC_PROJECT_DEPENDENCIES = BuildManager.class.getCanonicalName() + ".cyclicProjectDependencies";
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private WorkspaceManager workspaceManager;
    @Inject
    private Provider<TopologicalSorter> sorterProvider;
    private final LinkedHashSet<URI> dirtyFiles = CollectionLiterals.newLinkedHashSet((Object[])new URI[0]);
    private final LinkedHashSet<URI> deletedFiles = CollectionLiterals.newLinkedHashSet((Object[])new URI[0]);

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        this.queue(this.dirtyFiles, deletedFiles, dirtyFiles);
        this.queue(this.deletedFiles, dirtyFiles, deletedFiles);
        return this.internalBuild(cancelIndicator);
    }

    protected void queue(Set<URI> files, Collection<URI> toRemove, Collection<URI> toAdd) {
        Iterables.removeAll(files, toRemove);
        Iterables.addAll(files, toAdd);
    }

    public List<IResourceDescription.Delta> doInitialBuild(List<ProjectDescription> projects, CancelIndicator indicator) {
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies(projects);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        for (ProjectDescription description : sortedDescriptions) {
            String _name = description.getName();
            ProjectManager _projectManager = this.workspaceManager.getProjectManager(_name);
            IncrementalBuilder.Result partialresult = _projectManager.doInitialBuild(indicator);
            List _affectedResources = partialresult.getAffectedResources();
            result.addAll(_affectedResources);
        }
        return result;
    }

    protected List<IResourceDescription.Delta> internalBuild(CancelIndicator cancelIndicator) {
        ArrayList<URI> allDirty = new ArrayList<URI>(this.dirtyFiles);
        HashMultimap project2dirty = HashMultimap.create();
        for (URI uRI : allDirty) {
            ProjectManager _projectManager = this.workspaceManager.getProjectManager(uRI);
            ProjectDescription projectManager = _projectManager.getProjectDescription();
            project2dirty.put((Object)projectManager, (Object)uRI);
        }
        HashMultimap project2deleted = HashMultimap.create();
        for (URI deleted : this.deletedFiles) {
            ProjectManager _projectManager = this.workspaceManager.getProjectManager(deleted);
            ProjectDescription projectManager = _projectManager.getProjectDescription();
            project2deleted.put((Object)projectManager, (Object)deleted);
        }
        Set set = project2dirty.keySet();
        Set _keySet_1 = project2deleted.keySet();
        Iterable _plus = Iterables.concat((Iterable)set, (Iterable)_keySet_1);
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies(_plus);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new IResourceDescription.Delta[0]);
        for (ProjectDescription it : sortedDescriptions) {
            String _name = it.getName();
            ProjectManager projectManager = this.workspaceManager.getProjectManager(_name);
            Set _get = project2dirty.get((Object)it);
            List _list = IterableExtensions.toList((Iterable)_get);
            Set _get_1 = project2deleted.get((Object)it);
            List _list_1 = IterableExtensions.toList((Iterable)_get_1);
            IncrementalBuilder.Result partialResult = projectManager.doBuild(_list, _list_1, cancelIndicator);
            List _affectedResources = partialResult.getAffectedResources();
            Functions.Function1 _function = it_1 -> it_1.getUri();
            List _map = ListExtensions.map((List)_affectedResources, (Functions.Function1)_function);
            allDirty.addAll(_map);
            Iterables.removeAll(this.dirtyFiles, this.dirtyFiles);
            Iterables.removeAll(this.deletedFiles, this.deletedFiles);
            List _affectedResources_1 = partialResult.getAffectedResources();
            result.addAll(_affectedResources_1);
        }
        return result;
    }

    protected List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> projectDescriptions) {
        TopologicalSorter _get = (TopologicalSorter)this.sorterProvider.get();
        List _list = IterableExtensions.toList(projectDescriptions);
        Procedures.Procedure1 _function = it -> {
            String _name = it.getName();
            ProjectManager _projectManager = this.workspaceManager.getProjectManager(_name);
            this.reportDependencyCycle(_projectManager);
        };
        return _get.sortByDependencies(_list, (Procedures.Procedure1<? super ProjectDescription>)_function);
    }

    protected void reportDependencyCycle(ProjectManager manager) {
        manager.reportProjectIssue("Project has cyclic dependencies", CYCLIC_PROJECT_DEPENDENCIES, Severity.ERROR);
    }

    public void setWorkspaceManager(WorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    @Data
    protected static class ProjectBuildData {
        private final List<URI> dirtyFiles;
        private final List<URI> deletedFiles;

        public ProjectBuildData(List<URI> dirtyFiles, List<URI> deletedFiles) {
            this.dirtyFiles = dirtyFiles;
            this.deletedFiles = deletedFiles;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dirtyFiles == null ? 0 : this.dirtyFiles.hashCode());
            result = 31 * result + (this.deletedFiles == null ? 0 : this.deletedFiles.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectBuildData other = (ProjectBuildData)obj;
            if (this.dirtyFiles == null ? other.dirtyFiles != null : !this.dirtyFiles.equals(other.dirtyFiles)) {
                return false;
            }
            return !(this.deletedFiles == null ? other.deletedFiles != null : !this.deletedFiles.equals(other.deletedFiles));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("dirtyFiles", this.dirtyFiles);
            b.add("deletedFiles", this.deletedFiles);
            return b.toString();
        }

        @Pure
        public List<URI> getDirtyFiles() {
            return this.dirtyFiles;
        }

        @Pure
        public List<URI> getDeletedFiles() {
            return this.deletedFiles;
        }
    }
}

