/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.BuildExecutors;
import org.eclipse.xtext.builder.BuilderParticipant;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.ParallelFileSystemAccess;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.FileSystemAccessRequest;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;

public class ParallelBuilderParticipant
extends BuilderParticipant {
    @Inject
    private BuildExecutors executors;
    private static final int QUEUE_CAPACITY = 50;
    private static final int QUEUE_POLL_TIMEOUT = 50;

    @Override
    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess access) throws CoreException {
        this.handleChangedContents((ParallelBuildContext)context, (IFileSystemAccess2)access);
    }

    protected void handleChangedContents(ParallelBuildContext context, IFileSystemAccess2 access) throws CoreException {
        Resource resource = context.resource;
        this.saveResourceStorage(resource, (IFileSystemAccess)access);
        if (this.shouldGenerate(resource, context)) {
            this.getGenerator2().doGenerate(resource, access);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doBuild(List<IResourceDescription.Delta> deltas, Map<String, OutputConfiguration> outputConfigurations, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 access, IProgressMonitor progressMonitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cancelProcessing(BlockingQueue<FileSystemAccessRequest> requestQueue, ListenableFuture<?> generatorResult) {
        requestQueue.clear();
        generatorResult.cancel(true);
    }

    protected Runnable createRunnable(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, Map<String, OutputConfiguration> outputConfigurations, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, FileSystemAccessQueue fileSystemAccessQueue, IFileSystemAccess2 delegate, IProgressMonitor progressMonitor) {
        Resource resource = null;
        if (delta.getNew() != null) {
            resource = context.getResourceSet().getResource(delta.getUri(), true);
        }
        ParallelBuildContext parallelBuildContext = new ParallelBuildContext(delta, resource, context, outputConfigurations, generatorMarkers, fileSystemAccessQueue, (EclipseResourceFileSystemAccess2)delegate, progressMonitor);
        return this.createRunnable(parallelBuildContext);
    }

    protected Runnable createRunnable(final ParallelBuildContext buildContext) {
        final IGenerator2 generator = this.getGenerator2();
        final Resource resource = buildContext.resource;
        if (resource != null) {
            generator.beforeGenerate(resource, (IFileSystemAccess2)buildContext.synchronousFileSystemAccess);
        }
        return new Runnable(){

            @Override
            public void run() {
                IResourceDescription.Delta delta = buildContext.delta;
                try {
                    Set<IFile> derivedResources = ParallelBuilderParticipant.this.getDerivedResources(delta, buildContext.outputConfigurations, buildContext.generatorMarkers);
                    FileSystemAccessQueue fileSystemAccessQueue = buildContext.fileSystemAccessQueue;
                    IFileSystemAccess2 fsa = ParallelBuilderParticipant.this.getParalleFileSystemAccess(delta, buildContext, derivedResources, fileSystemAccessQueue, (IFileSystemAccess2)buildContext.synchronousFileSystemAccess);
                    boolean generated = ParallelBuilderParticipant.this.doGenerate(delta, buildContext, (IFileSystemAccess)fsa);
                    final Runnable derivedResourceCallback = ParallelBuilderParticipant.this.getFlushAndCleanDerivedResourcesCallback(buildContext, derivedResources, generated);
                    fileSystemAccessQueue.sendAsync(delta.getUri(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                derivedResourceCallback.run();
                            }
                            finally {
                                if (resource != null) {
                                    generator.afterGenerate(resource, (IFileSystemAccess2)buildContext.synchronousFileSystemAccess);
                                }
                            }
                        }
                    });
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (Throwable e) {
                    ParallelBuilderParticipant.this.addMarkerAndLogError(delta.getUri(), e);
                }
            }
        };
    }

    @Override
    protected boolean doGenerate(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IFileSystemAccess access) throws OperationCanceledException {
        if (delta.getNew() != null) {
            try {
                this.handleChangedContents(delta, context, access);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                this.addMarkerAndLogError(delta.getUri(), e);
            }
            return true;
        }
        return false;
    }

    protected <E> BlockingQueue<E> newBlockingQueue(int capacity) {
        return new LinkedBlockingQueue(capacity);
    }

    protected Runnable getFlushAndCleanDerivedResourcesCallback(final ParallelBuildContext buildContext, final Set<IFile> derivedResources, final boolean generated) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseResourceFileSystemAccess2 synchronousFileSystemAccess = buildContext.synchronousFileSystemAccess;
                    if (generated) {
                        synchronousFileSystemAccess.flushSourceTraces();
                    }
                    ParallelBuilderParticipant.this.cleanDerivedResources(buildContext.delta, derivedResources, buildContext, synchronousFileSystemAccess, buildContext.progressMonitor);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected IFileSystemAccess2 getParalleFileSystemAccess(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, Set<IFile> derivedResources, FileSystemAccessQueue fileSystemAccessQueue, IFileSystemAccess2 delegate) {
        String currentSourceFolder = this.getCurrentSourceFolder(context, delta);
        EclipseResourceFileSystemAccess2.IFileCallback postProcessor = this.getPostProcessor(delta, context, derivedResources);
        return new ParallelFileSystemAccess(delegate, delta, fileSystemAccessQueue, currentSourceFolder, postProcessor);
    }

    protected static class ParallelBuildContext
    implements IXtextBuilderParticipant.IBuildContext {
        final IResourceDescription.Delta delta;
        final IXtextBuilderParticipant.IBuildContext buildContextDelegate;
        final Map<String, OutputConfiguration> outputConfigurations;
        final Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers;
        final FileSystemAccessQueue fileSystemAccessQueue;
        final EclipseResourceFileSystemAccess2 synchronousFileSystemAccess;
        final IProgressMonitor progressMonitor;
        final Resource resource;

        public ParallelBuildContext(IResourceDescription.Delta delta, Resource resource, IXtextBuilderParticipant.IBuildContext buildContextDelegate, Map<String, OutputConfiguration> outputConfigurations, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, FileSystemAccessQueue fileSystemAccessQueue, EclipseResourceFileSystemAccess2 delegate, IProgressMonitor progressMonitor) {
            this.delta = delta;
            this.resource = resource;
            this.buildContextDelegate = buildContextDelegate;
            this.outputConfigurations = outputConfigurations;
            this.generatorMarkers = generatorMarkers;
            this.fileSystemAccessQueue = fileSystemAccessQueue;
            this.synchronousFileSystemAccess = delegate;
            this.progressMonitor = progressMonitor;
        }

        public URI getURI() {
            return this.delta.getUri();
        }

        @Override
        public IProject getBuiltProject() {
            return this.buildContextDelegate.getBuiltProject();
        }

        @Override
        public List<IResourceDescription.Delta> getDeltas() {
            return this.buildContextDelegate.getDeltas();
        }

        @Override
        public ResourceSet getResourceSet() {
            return this.buildContextDelegate.getResourceSet();
        }

        @Override
        public IXtextBuilderParticipant.BuildType getBuildType() {
            return this.buildContextDelegate.getBuildType();
        }

        @Override
        public void needRebuild() {
            this.buildContextDelegate.needRebuild();
        }

        @Override
        public boolean isSourceLevelURI(URI uri) {
            return this.buildContextDelegate.isSourceLevelURI(uri);
        }
    }
}

