/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtext.builder.standalone.incremental.BinaryFileHashing;
import org.eclipse.xtext.builder.standalone.incremental.ClasspathEntryHash;
import org.eclipse.xtext.builder.standalone.incremental.ClasspathEntryHashVisitor;

public class FineGrainedEntryHash
implements ClasspathEntryHash {
    private final Map<IPath, HashCode> classHashes;

    public FineGrainedEntryHash(Map<IPath, HashCode> classHashes) {
        this.classHashes = classHashes;
    }

    @Override
    public void accept(ClasspathEntryHashVisitor visitor) {
        this.classHashes.forEach(visitor::visitClassFile);
    }

    public Map<IPath, HashCode> classHashes() {
        return Collections.unmodifiableMap(this.classHashes);
    }

    @Override
    public String asString() {
        Stream<Map.Entry> sorted = this.classHashes.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, Comparator.comparing(IPath::toString)));
        Stream<byte[]> bytes = sorted.map(Map.Entry::getValue).map(HashCode::asBytes);
        Hasher hasher = BinaryFileHashing.hashFunction().newHasher();
        bytes.forEachOrdered(arg_0 -> ((Hasher)hasher).putBytes(arg_0));
        return hasher.hash().toString();
    }
}

