/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseJavaCompiler
implements IJavaCompiler {
    @Inject
    private CompilerConfiguration configuration;
    private Iterable<String> classPath;
    private Writer errorWriter;
    private Writer outputWriter;
    private static final Logger LOG = Logger.getLogger(EclipseJavaCompiler.class);

    @Override
    public IJavaCompiler.CompilationResult compile(Iterable<String> sourceRoots, File outputClassDirectory) {
        boolean result;
        Iterable validClasspath;
        Iterable validSourceRoots = IterableExtensions.filter(sourceRoots, (Functions.Function1)new EmptyOrMissingFilter());
        if (!this.containsJavaFiles(validSourceRoots)) {
            return IJavaCompiler.CompilationResult.SKIPPED;
        }
        ArrayList commandLine = Lists.newArrayList();
        if (this.configuration.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (this.classPath != null && (validClasspath = IterableExtensions.filter(this.classPath, (Functions.Function1)new EmptyOrMissingFilter())).iterator().hasNext()) {
            commandLine.add("-cp \"" + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)validClasspath)) + "\"");
        }
        commandLine.add("-d \"" + outputClassDirectory.toString() + "\"");
        commandLine.add("-source " + this.configuration.getSourceLevel());
        commandLine.add("-target " + this.configuration.getTargetLevel());
        commandLine.add("-proceedOnError");
        commandLine.add(IterableExtensions.join((Iterable)validSourceRoots, (CharSequence)" "));
        String cmdLine = Strings.concat((String)" ", (List)commandLine);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("invoke batch compiler with '" + cmdLine + "'"));
        }
        return (result = BatchCompiler.compile((String)cmdLine, (PrintWriter)new PrintWriter(this.getOutputWriter()), (PrintWriter)new PrintWriter(this.getErrorWriter()), null)) ? IJavaCompiler.CompilationResult.SUCCEEDED : IJavaCompiler.CompilationResult.FAILED;
    }

    public Writer getOutputWriter() {
        if (this.outputWriter == null) {
            this.outputWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        LOG.info((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.outputWriter;
    }

    public void setOutputWriter(Writer ouputWriter) {
        this.outputWriter = ouputWriter;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        LOG.warn((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    @Override
    public void setClassPath(Iterable<String> classPath) {
        this.classPath = classPath;
    }

    private boolean containsJavaFiles(Iterable<String> roots) {
        Multimap uris = new PathTraverser().resolvePathes((List)Lists.newArrayList(roots), (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return "java".equals(input.fileExtension());
            }
        });
        return uris.values().size() > 0;
    }

    @Override
    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EmptyOrMissingFilter
    implements Functions.Function1<String, Boolean> {
        private EmptyOrMissingFilter() {
        }

        public Boolean apply(String path) {
            File file = new File(path);
            boolean useEntry = file.exists();
            if (LOG.isDebugEnabled() && !useEntry) {
                LOG.debug((Object)("File '" + path + "' is missing. Skipping."));
            }
            return useEntry;
        }
    }
}

