/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.AbstractXtendCompilerMojo;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendCompile
extends AbstractXtendCompilerMojo {
    private String outputDirectory;
    private String tempDirectory;

    @Override
    protected void internalExecute() throws MojoExecutionException {
        String defaultValue = this.project.getBasedir() + "/src/main/generated-sources/xtend";
        this.getLog().debug((CharSequence)("Output directory '" + this.outputDirectory + "'"));
        this.getLog().debug((CharSequence)("Default directory '" + defaultValue + "'"));
        if (defaultValue.equals(this.outputDirectory)) {
            this.readXtendEclipseSetting(this.project.getBuild().getSourceDirectory(), new Procedures.Procedure1<String>(){

                public void apply(String xtendOutputDir) {
                    XtendCompile.this.outputDirectory = xtendOutputDir;
                    XtendCompile.this.getLog().info((CharSequence)("Using Xtend output directory '" + XtendCompile.this.outputDirectory + "'"));
                }
            });
        }
        this.outputDirectory = this.resolveToBaseDir(this.outputDirectory);
        this.compileSources((XtendBatchCompiler)this.xtendBatchCompilerProvider.get());
    }

    private void compileSources(XtendBatchCompiler xtend2BatchCompiler) throws MojoExecutionException {
        ArrayList compileSourceRoots = Lists.newArrayList((Iterable)this.project.getCompileSourceRoots());
        String classPath = Strings.concat((String)File.pathSeparator, this.getClassPath());
        this.project.addCompileSourceRoot(this.outputDirectory);
        this.compile(xtend2BatchCompiler, classPath, compileSourceRoots, this.outputDirectory);
    }

    protected List<String> getClassPath() {
        LinkedHashSet classPath = Sets.newLinkedHashSet();
        classPath.add(this.project.getBuild().getSourceDirectory());
        try {
            classPath.addAll(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new WrappedException((Exception)((Object)e));
        }
        this.addDependencies(classPath, this.project.getCompileArtifacts());
        classPath.remove(this.project.getBuild().getOutputDirectory());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)classPath, (Predicate)FILE_EXISTS));
    }

    @Override
    protected String getTempDirectory() {
        return this.tempDirectory;
    }
}

