/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.maven.AbstractXtendMojo;
import org.eclipse.xtend.maven.MavenProjectResourceSetProvider;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class AbstractXtendCompilerMojo
extends AbstractXtendMojo {
    protected static final Predicate<String> FILE_EXISTS = new Predicate<String>(){

        public boolean apply(String filePath) {
            return new File(filePath).exists();
        }
    };
    private String javaSourceVersion;
    private ToolchainManager toolchainManager;
    private MavenSession session;
    private String encoding;
    private boolean writeTraceFiles;
    private String propertiesFileLocation;
    private boolean generateSyntheticSuppressWarnings;
    private boolean generateGeneratedAnnotation;
    private boolean includeDateInGeneratedAnnotation;
    private String generatedAnnotationComment;
    @Inject
    private Provider<XtendBatchCompiler> xtendBatchCompilerProvider;

    protected XtendBatchCompiler getBatchCompiler() {
        return (XtendBatchCompiler)this.xtendBatchCompilerProvider.get();
    }

    protected void compile(String classPath, List<String> sourcePaths, String outputPath) throws MojoExecutionException {
        XtendBatchCompiler compiler = this.getBatchCompiler();
        Log log = this.getLog();
        compiler.setResourceSetProvider((Provider)new MavenProjectResourceSetProvider(this.project));
        Iterable filtered = Iterables.filter(sourcePaths, FILE_EXISTS);
        if (Iterables.isEmpty((Iterable)filtered)) {
            String dir = Iterables.toString(sourcePaths);
            log.info((CharSequence)("skip compiling sources because the configured directory '" + dir + "' does not exist."));
            return;
        }
        String baseDir = this.project.getBasedir().getAbsolutePath();
        log.debug((CharSequence)("Set Java Compliance Level: " + this.javaSourceVersion));
        compiler.setJavaSourceVersion(this.javaSourceVersion);
        log.debug((CharSequence)("Set generateSyntheticSuppressWarnings: " + this.generateSyntheticSuppressWarnings));
        compiler.setGenerateSyntheticSuppressWarnings(this.generateSyntheticSuppressWarnings);
        log.debug((CharSequence)("Set generateGeneratedAnnotation: " + this.generateGeneratedAnnotation));
        compiler.setGenerateGeneratedAnnotation(this.generateGeneratedAnnotation);
        log.debug((CharSequence)("Set includeDateInGeneratedAnnotation: " + this.includeDateInGeneratedAnnotation));
        compiler.setIncludeDateInGeneratedAnnotation(this.includeDateInGeneratedAnnotation);
        log.debug((CharSequence)("Set generatedAnnotationComment: " + this.generatedAnnotationComment));
        compiler.setGeneratedAnnotationComment(this.generatedAnnotationComment);
        log.debug((CharSequence)("Set baseDir: " + baseDir));
        compiler.setBasePath(baseDir);
        log.debug((CharSequence)("Set temp directory: " + this.getTempDirectory()));
        compiler.setTempDirectory(this.getTempDirectory());
        log.debug((CharSequence)"Set DeleteTempDirectory: false");
        compiler.setDeleteTempDirectory(false);
        log.debug((CharSequence)("Set classpath: " + classPath));
        compiler.setClassPath(classPath);
        String bootClassPath = this.getBootClassPath();
        log.debug((CharSequence)("Set bootClasspath: " + bootClassPath));
        compiler.setBootClassPath(bootClassPath);
        log.debug((CharSequence)("Set source path: " + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered))));
        compiler.setSourcePath(Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered)));
        log.debug((CharSequence)("Set output path: " + outputPath));
        compiler.setOutputPath(outputPath);
        log.debug((CharSequence)("Set encoding: " + this.encoding));
        compiler.setFileEncoding(this.encoding);
        log.debug((CharSequence)("Set writeTraceFiles: " + this.writeTraceFiles));
        compiler.setWriteTraceFiles(this.writeTraceFiles);
        if (!compiler.compile()) {
            String dir = Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)filtered));
            throw new MojoExecutionException("Error compiling xtend sources in '" + dir + "'.");
        }
    }

    private String getBootClassPath() {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain instanceof DefaultJavaToolChain) {
            Xpp3Dom bootClassPath;
            JavaVersion version;
            DefaultJavaToolChain javaToolChain = (DefaultJavaToolChain)toolchain;
            this.getLog().info((CharSequence)("Using toolchain " + javaToolChain));
            if (this.javaSourceVersion != null && (version = JavaVersion.fromQualifier((String)this.javaSourceVersion)).isAtLeast(JavaVersion.JAVA9)) {
                return "";
            }
            String[] includes = new String[]{"jre/lib/*", "jre/lib/ext/*", "jre/lib/endorsed/*"};
            String[] excludes = new String[]{};
            Xpp3Dom config = (Xpp3Dom)javaToolChain.getModel().getConfiguration();
            if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null) {
                Xpp3Dom excludeParent;
                Xpp3Dom includeParent = bootClassPath.getChild("includes");
                if (includeParent != null) {
                    includes = this.getValues(includeParent.getChildren("include"));
                }
                if ((excludeParent = bootClassPath.getChild("excludes")) != null) {
                    excludes = this.getValues(excludeParent.getChildren("exclude"));
                }
            }
            return this.scanBootclasspath(javaToolChain.getJavaHome(), includes, excludes);
        }
        return "";
    }

    private String scanBootclasspath(String javaHome, String[] includes, String[] excludes) {
        this.getLog().debug((CharSequence)("Scanning bootClassPath:\n\tjavaHome = " + javaHome + "\n" + "\tincludes = " + Arrays.toString(includes) + "\n" + "\texcludes = " + Arrays.toString(excludes)));
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(javaHome));
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        StringBuilder bootClassPath = new StringBuilder();
        String[] includedFiles = scanner.getIncludedFiles();
        int i = 0;
        while (i < includedFiles.length) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(new File(javaHome, includedFiles[i]).getAbsolutePath());
            ++i;
        }
        return bootClassPath.toString();
    }

    private String[] getValues(Xpp3Dom[] children) {
        String[] values = new String[children.length];
        int i = 0;
        while (i < values.length) {
            values[i] = children[i].getValue();
            ++i;
        }
        return values;
    }

    protected abstract String getTempDirectory();

    protected void addDependencies(Set<String> classPath, List<Artifact> dependencies) {
        for (Artifact artifact : dependencies) {
            classPath.add(artifact.getFile().getAbsolutePath());
        }
    }

    protected void readXtendEclipseSetting(String sourceDirectory, Procedures.Procedure1<String> fieldSetter) {
        block7: {
            if (this.propertiesFileLocation != null) {
                File f = new File(this.propertiesFileLocation);
                if (f.canRead()) {
                    Properties xtendSettings = new Properties();
                    try {
                        xtendSettings.load(new FileInputStream(f));
                        String xtendOutputDirProp = xtendSettings.getProperty("outlet.DEFAULT_OUTPUT.directory", null);
                        if (xtendOutputDirProp == null) break block7;
                        File srcDir = new File(sourceDirectory);
                        this.getLog().debug((CharSequence)("Source dir : " + srcDir.getPath() + " exists " + srcDir.exists()));
                        if (srcDir.exists() && srcDir.getParent() != null) {
                            String path = new File(srcDir.getParent(), xtendOutputDirProp).getPath();
                            this.getLog().debug((CharSequence)("Applying Xtend property: " + xtendOutputDirProp));
                            fieldSetter.apply((Object)path);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.getLog().warn((Throwable)e);
                    }
                    catch (IOException e) {
                        this.getLog().warn((Throwable)e);
                    }
                } else {
                    this.getLog().info((CharSequence)("Can't find Xtend properties under " + this.propertiesFileLocation + ", maven defaults are used."));
                }
            }
        }
    }

    protected String resolveToBaseDir(String directory) throws MojoExecutionException {
        File outDir = new File(directory);
        if (!outDir.isAbsolute()) {
            outDir = new File(this.project.getBasedir(), directory);
        }
        return outDir.getAbsolutePath();
    }
}

