/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.ResolvedTypeParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class DelegateProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, @Extension TransformationContext context) {
        Util util = new Util(context);
        Consumer<MutableMemberDeclaration> _function = it -> {
            boolean _isValidDelegate = util.isValidDelegate((MemberDeclaration)it);
            if (_isValidDelegate) {
                Set<ResolvedMethod> _methodsToImplement = util.getMethodsToImplement((MemberDeclaration)it);
                Consumer<ResolvedMethod> _function_1 = method -> util.implementMethod((MutableMemberDeclaration)it, (ResolvedMethod)method);
                _methodsToImplement.forEach(_function_1);
            }
        };
        elements.forEach(_function);
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        protected boolean _isValidDelegate(FieldDeclaration it) {
            return this.hasValidType((MemberDeclaration)it) && !this.hasDelegationConflicts((MemberDeclaration)it) && this.areListedInterfacesValid((MemberDeclaration)it);
        }

        protected boolean _isValidDelegate(MethodDeclaration it) {
            return this.hasValidType((MemberDeclaration)it) && this.hasValidSignature(it) && !this.hasDelegationConflicts((MemberDeclaration)it) && this.areListedInterfacesValid((MemberDeclaration)it);
        }

        public boolean hasValidType(MemberDeclaration it) {
            boolean _xifexpression = false;
            if (this.getType(it) == null || this.getType(it).isInferred()) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Cannot use inferred types on delegates");
                _xifexpression = _xblockexpression = false;
            } else {
                _xifexpression = true;
            }
            return _xifexpression;
        }

        protected TypeReference _getType(FieldDeclaration it) {
            return it.getType();
        }

        protected TypeReference _getType(MethodDeclaration it) {
            return it.getReturnType();
        }

        public boolean hasValidSignature(MethodDeclaration it) {
            boolean _switchResult = false;
            Iterable _parameters = it.getParameters();
            Functions.Function1 _function = it_1 -> it_1.getType();
            Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
            List _list = IterableExtensions.toList((Iterable)_map);
            boolean _matched = false;
            if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[0])))) {
                _matched = true;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string})))) {
                    _matched = true;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newWildcardTypeReference = this.context.newWildcardTypeReference();
                TypeReference _newTypeReference = this.context.newTypeReference(Class.class, new TypeReference[]{_newWildcardTypeReference});
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(_newTypeReference);
                TypeReference _object = this.context.getObject();
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(_object);
                if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1, _newArrayTypeReference, _newArrayTypeReference_1})))) {
                    _matched = true;
                }
            }
            if (_matched) {
                _switchResult = true;
            }
            if (!_matched) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Not a valid delegate signature, use () or (String methodName) or (String methodName, Class<?>[] argumentTypes, Object[] arguments)");
                _switchResult = _xblockexpression = false;
            }
            return _switchResult;
        }

        public boolean hasDelegationConflicts(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            boolean conflict = false;
            Iterable<? extends MemberDeclaration> _otherDelegates = this.otherDelegates(delegate);
            for (MemberDeclaration memberDeclaration : _otherDelegates) {
                Set<TypeReference> otherInterfaces = this.getDelegatedInterfaces(memberDeclaration);
                Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
                for (TypeReference iface : _delegatedInterfaces) {
                    boolean _contains = otherInterfaces.contains(iface);
                    if (!_contains) continue;
                    conflict = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The interface ");
                    String _simpleName = iface.getSimpleName();
                    _builder.append(_simpleName, "");
                    _builder.append(" is also implemented by the delegate ");
                    String _simpleName_1 = memberDeclaration.getSimpleName();
                    _builder.append(_simpleName_1, "");
                    this.context.addError((Element)delegate, _builder.toString());
                }
            }
            _xblockexpression = conflict;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> otherDelegates(MemberDeclaration delegate) {
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            Iterable<? extends MemberDeclaration> _delegates = this.getDelegates(_declaringType);
            Functions.Function1 _function = it -> !Objects.equal((Object)it, (Object)delegate);
            return IterableExtensions.filter(_delegates, (Functions.Function1)_function);
        }

        public boolean areListedInterfacesValid(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            TypeReference declaringType = this.context.newSelfTypeReference((Type)_declaringType);
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(declaringType);
            TypeReference _type = this.getType(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(_type);
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            boolean valid = true;
            for (TypeReference iface : listedInterfaces) {
                Functions.Function1 _function_1;
                boolean _exists_1;
                boolean _not_1;
                boolean _not;
                Functions.Function1 _function = it -> {
                    Type _type_1 = it.getType();
                    Type _type_2 = iface.getType();
                    return Objects.equal((Object)_type_1, (Object)_type_2);
                };
                boolean _exists = IterableExtensions.exists(availableInterfaces, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    TypeReference _type_1 = this.getType(delegate);
                    String _simpleName = _type_1.getSimpleName();
                    _builder.append(_simpleName, "");
                    _builder.append(" does not implement ");
                    String _simpleName_1 = iface.getSimpleName();
                    _builder.append(_simpleName_1, "");
                    this.context.addError((Element)delegate, _builder.toString());
                    valid = false;
                }
                if (!(_not_1 = !(_exists_1 = IterableExtensions.exists(interfacesOfDeclaringType, (Functions.Function1)(_function_1 = it -> {
                    Type _type_2 = it.getType();
                    Type _type_3 = iface.getType();
                    return Objects.equal((Object)_type_2, (Object)_type_3);
                }))))) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_2 = declaringType.getSimpleName();
                _builder_1.append(_simpleName_2, "");
                _builder_1.append(" does not implement ");
                String _simpleName_3 = iface.getSimpleName();
                _builder_1.append(_simpleName_3, "");
                this.context.addError((Element)delegate, _builder_1.toString());
                valid = false;
            }
            if (listedInterfaces.isEmpty() && Sets.intersection(interfacesOfDeclaringType, availableInterfaces).isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                TypeReference _type_1 = this.getType(delegate);
                String _simpleName = _type_1.getSimpleName();
                _builder.append(_simpleName, "");
                _builder.append(" and ");
                String _simpleName_1 = declaringType.getSimpleName();
                _builder.append(_simpleName_1, "");
                _builder.append(" have no interfaces in common");
                this.context.addError((Element)delegate, _builder.toString());
                valid = false;
            }
            _xblockexpression = valid;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> getDelegates(TypeDeclaration it) {
            Iterable _declaredMembers = it.getDeclaredMembers();
            Functions.Function1 _function = it_1 -> {
                Type _findTypeGlobally = this.context.findTypeGlobally(Delegate.class);
                AnnotationReference _findAnnotation = it_1.findAnnotation(_findTypeGlobally);
                return _findAnnotation != null;
            };
            return IterableExtensions.filter((Iterable)_declaredMembers, (Functions.Function1)_function);
        }

        public Set<TypeReference> listedInterfaces(MemberDeclaration it) {
            Type _findTypeGlobally = this.context.findTypeGlobally(Delegate.class);
            AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
            TypeReference[] _classArrayValue = _findAnnotation.getClassArrayValue("value");
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_classArrayValue)));
        }

        public Set<TypeReference> getImplementedInterfaces(TypeReference it) {
            Set _xblockexpression = null;
            LinkedHashSet seen = CollectionLiterals.newLinkedHashSet((Object[])new TypeReference[0]);
            this.collectAllSuperTypes(it, seen);
            Functions.Function1 _function = it_1 -> {
                Type _type = it_1.getType();
                return _type instanceof InterfaceDeclaration;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)seen, (Functions.Function1)_function);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            return _xblockexpression;
        }

        private void collectAllSuperTypes(TypeReference it, Set<TypeReference> seen) {
            boolean cycle;
            boolean _add = seen.add(it);
            boolean bl = cycle = !_add;
            if (cycle) {
                return;
            }
            Iterable _declaredSuperTypes = it.getDeclaredSuperTypes();
            Consumer<TypeReference> _function = it_1 -> this.collectAllSuperTypes((TypeReference)it_1, seen);
            _declaredSuperTypes.forEach(_function);
        }

        public Set<TypeReference> getDelegatedInterfaces(MemberDeclaration delegate) {
            Set _xblockexpression = null;
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            TypeReference _newSelfTypeReference = this.context.newSelfTypeReference((Type)_declaringType);
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(_newSelfTypeReference);
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            TypeReference _type = this.getType(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(_type);
            Functions.Function1 _function = iface -> interfacesOfDeclaringType.contains(iface) && (listedInterfaces.isEmpty() || IterableExtensions.exists((Iterable)listedInterfaces, it -> iface.isAssignableFrom(it)));
            Iterable _filter = IterableExtensions.filter(availableInterfaces, (Functions.Function1)_function);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            return _xblockexpression;
        }

        public Set<ResolvedMethod> getMethodsToImplement(MemberDeclaration delegate) {
            Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
            Functions.Function1 _function = it -> it.getDeclaredResolvedMethods();
            Iterable _map = IterableExtensions.map(_delegatedInterfaces, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Functions.Function1 _function_1 = it -> {
                Functions.Function1 _function_2;
                Iterable _resolvedParameters;
                Iterable _map_1;
                MethodDeclaration _declaration;
                String _simpleName;
                TypeDeclaration _declaringType = delegate.getDeclaringType();
                MethodDeclaration _findDeclaredMethod = _declaringType.findDeclaredMethod(_simpleName = (_declaration = it.getDeclaration()).getSimpleName(), (TypeReference[])Conversions.unwrapArray((Object)(_map_1 = IterableExtensions.map((Iterable)(_resolvedParameters = it.getResolvedParameters()), (Functions.Function1)(_function_2 = it_1 -> it_1.getResolvedType()))), TypeReference.class));
                return _findDeclaredMethod == null;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_1);
            Functions.Function1 _function_2 = it -> {
                boolean _isObjectMethod = this.isObjectMethod((ResolvedMethod)it);
                return !_isObjectMethod;
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = it -> it.getSimpleSignature();
            Map _groupBy = IterableExtensions.groupBy((Iterable)_filter_1, (Functions.Function1)_function_3);
            Collection _values = _groupBy.values();
            Functions.Function1 _function_4 = it -> (ResolvedMethod)IterableExtensions.head((Iterable)it);
            Iterable _map_1 = IterableExtensions.map(_values, (Functions.Function1)_function_4);
            return IterableExtensions.toSet((Iterable)_map_1);
        }

        public boolean isObjectMethod(ResolvedMethod it) {
            boolean _xblockexpression = false;
            MethodDeclaration _declaration = it.getDeclaration();
            String name = _declaration.getSimpleName();
            Iterable _resolvedParameters = it.getResolvedParameters();
            Functions.Function1 _function = it_1 -> it_1.getResolvedType();
            Iterable _map = IterableExtensions.map((Iterable)_resolvedParameters, (Functions.Function1)_function);
            List parameterTypes = IterableExtensions.toList((Iterable)_map);
            _xblockexpression = Objects.equal((Object)name, (Object)"hashCode") && parameterTypes.isEmpty() || Objects.equal((Object)name, (Object)"toString") && parameterTypes.isEmpty() || Objects.equal((Object)name, (Object)"equals") && Objects.equal((Object)parameterTypes, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{this.context.getObject()}))) || Objects.equal((Object)name, (Object)"finalize") && parameterTypes.isEmpty() || Objects.equal((Object)name, (Object)"clone") && parameterTypes.isEmpty();
            return _xblockexpression;
        }

        public MutableMethodDeclaration implementMethod(final MutableMemberDeclaration delegate, final ResolvedMethod resolvedMethod) {
            MutableMethodDeclaration _xblockexpression = null;
            delegate.markAsRead();
            final MethodDeclaration declaration = resolvedMethod.getDeclaration();
            MutableTypeDeclaration _declaringType = delegate.getDeclaringType();
            String _simpleName = declaration.getSimpleName();
            Procedures.Procedure1 _function = impl -> {
                Element _primarySourceElement = this.context.getPrimarySourceElement((Element)delegate);
                this.context.setPrimarySourceElement((MutableElement)impl, _primarySourceElement);
                HashMap typeParameterMappings = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                Iterable _resolvedTypeParameters = resolvedMethod.getResolvedTypeParameters();
                Consumer<ResolvedTypeParameter> _function_1 = param -> {
                    TypeParameterDeclaration _declaration = param.getDeclaration();
                    String _simpleName_1 = _declaration.getSimpleName();
                    Iterable _resolvedUpperBounds = param.getResolvedUpperBounds();
                    MutableTypeParameterDeclaration copy = impl.addTypeParameter(_simpleName_1, (TypeReference[])Conversions.unwrapArray((Object)_resolvedUpperBounds, TypeReference.class));
                    TypeParameterDeclaration _declaration_1 = param.getDeclaration();
                    TypeReference _newTypeReference = this.context.newTypeReference((Type)_declaration_1, new TypeReference[0]);
                    TypeReference _newTypeReference_1 = this.context.newTypeReference((Type)copy, new TypeReference[0]);
                    typeParameterMappings.put(_newTypeReference, _newTypeReference_1);
                    Iterable _upperBounds = copy.getUpperBounds();
                    Functions.Function1 _function_2 = it -> this.replace((TypeReference)it, typeParameterMappings);
                    Iterable _map = IterableExtensions.map((Iterable)_upperBounds, (Functions.Function1)_function_2);
                    copy.setUpperBounds(_map);
                };
                _resolvedTypeParameters.forEach(_function_1);
                Iterable _resolvedExceptionTypes = resolvedMethod.getResolvedExceptionTypes();
                Functions.Function1 _function_2 = it -> this.replace((TypeReference)it, typeParameterMappings);
                Iterable _map = IterableExtensions.map((Iterable)_resolvedExceptionTypes, (Functions.Function1)_function_2);
                impl.setExceptions((TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
                boolean _isVarArgs = declaration.isVarArgs();
                impl.setVarArgs(_isVarArgs);
                TypeReference _resolvedReturnType = resolvedMethod.getResolvedReturnType();
                TypeReference _replace = this.replace(_resolvedReturnType, typeParameterMappings);
                impl.setReturnType(_replace);
                Iterable _resolvedParameters = resolvedMethod.getResolvedParameters();
                Consumer<ResolvedParameter> _function_3 = p -> {
                    ParameterDeclaration _declaration = p.getDeclaration();
                    String _simpleName_1 = _declaration.getSimpleName();
                    TypeReference _resolvedType = p.getResolvedType();
                    TypeReference _replace_1 = this.replace(_resolvedType, typeParameterMappings);
                    impl.addParameter(_simpleName_1, _replace_1);
                };
                _resolvedParameters.forEach(_function_3);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        String _returnIfNeeded = this.returnIfNeeded(resolvedMethod);
                        _builder.append((Object)_returnIfNeeded, "");
                        CharSequence _delegateAccess = this.delegateAccess((MemberDeclaration)delegate, declaration);
                        _builder.append((Object)_delegateAccess, "");
                        _builder.append((Object)".");
                        String _simpleName = declaration.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)"(");
                        Iterable _parameters = declaration.getParameters();
                        Functions.Function1 _function = it -> it.getSimpleName();
                        String _join = IterableExtensions.join((Iterable)_parameters, (CharSequence)", ", (Functions.Function1)_function);
                        _builder.append((Object)_join, "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                };
                impl.setBody(_client);
            };
            _xblockexpression = _declaringType.addMethod(_simpleName, _function);
            return _xblockexpression;
        }

        public TypeReference replace(TypeReference target, Map<? extends TypeReference, ? extends TypeReference> mappings) {
            Set<Map.Entry<? extends TypeReference, ? extends TypeReference>> _entrySet = mappings.entrySet();
            Functions.Function2 _function = (result, mapping) -> {
                TypeReference _key = (TypeReference)mapping.getKey();
                TypeReference _value = (TypeReference)mapping.getValue();
                return this.replace((TypeReference)result, _key, _value);
            };
            return (TypeReference)IterableExtensions.fold(_entrySet, (Object)target, (Functions.Function2)_function);
        }

        public TypeReference replace(TypeReference target, TypeReference oldType, TypeReference newType) {
            boolean _isArray;
            boolean _not;
            boolean _equals = Objects.equal((Object)target, (Object)oldType);
            if (_equals) {
                return newType;
            }
            List _actualTypeArguments = target.getActualTypeArguments();
            boolean _isEmpty = _actualTypeArguments.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Type _type = target.getType();
                List _actualTypeArguments_1 = target.getActualTypeArguments();
                Functions.Function1 _function = it -> this.replace((TypeReference)it, oldType, newType);
                List _map = ListExtensions.map((List)_actualTypeArguments_1, (Functions.Function1)_function);
                return this.context.newTypeReference(_type, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
            }
            boolean _isWildCard = target.isWildCard();
            if (_isWildCard) {
                boolean _not_1;
                TypeReference _object;
                boolean _notEquals;
                TypeReference _upperBound = target.getUpperBound();
                boolean bl2 = _notEquals = !Objects.equal((Object)_upperBound, (Object)(_object = this.context.getObject()));
                if (_notEquals) {
                    TypeReference _upperBound_1 = target.getUpperBound();
                    TypeReference _replace = this.replace(_upperBound_1, oldType, newType);
                    return this.context.newWildcardTypeReference(_replace);
                }
                TypeReference _lowerBound = target.getLowerBound();
                boolean _isAnyType = _lowerBound.isAnyType();
                boolean bl3 = _not_1 = !_isAnyType;
                if (_not_1) {
                    TypeReference _lowerBound_1 = target.getLowerBound();
                    TypeReference _replace_1 = this.replace(_lowerBound_1, oldType, newType);
                    return this.context.newWildcardTypeReferenceWithLowerBound(_replace_1);
                }
            }
            if (_isArray = target.isArray()) {
                TypeReference _arrayComponentType = target.getArrayComponentType();
                TypeReference _replace_2 = this.replace(_arrayComponentType, oldType, newType);
                return this.context.newArrayTypeReference(_replace_2);
            }
            return target;
        }

        protected CharSequence _delegateAccess(FieldDeclaration it, MethodDeclaration method) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this.");
            String _simpleName = it.getSimpleName();
            _builder.append(_simpleName, "");
            return _builder;
        }

        protected CharSequence _delegateAccess(MethodDeclaration it, MethodDeclaration method) {
            StringConcatenation _switchResult = null;
            Iterable _parameters = it.getParameters();
            Functions.Function1 _function = it_1 -> it_1.getType();
            Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
            List _list = IterableExtensions.toList((Iterable)_map);
            boolean _matched = false;
            if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[0])))) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("this.");
                String _simpleName = it.getSimpleName();
                _builder.append(_simpleName, "");
                _builder.append("()");
                _switchResult = _builder;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string})))) {
                    _matched = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("this.");
                    String _simpleName_1 = it.getSimpleName();
                    _builder_1.append(_simpleName_1, "");
                    _builder_1.append("(\"");
                    String _simpleName_2 = method.getSimpleName();
                    _builder_1.append(_simpleName_2, "");
                    _builder_1.append("\")");
                    _switchResult = _builder_1;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newWildcardTypeReference = this.context.newWildcardTypeReference();
                TypeReference _newTypeReference = this.context.newTypeReference(Class.class, new TypeReference[]{_newWildcardTypeReference});
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(_newTypeReference);
                TypeReference _object = this.context.getObject();
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(_object);
                if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1, _newArrayTypeReference, _newArrayTypeReference_1})))) {
                    _matched = true;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("this.");
                    String _simpleName_3 = it.getSimpleName();
                    _builder_2.append(_simpleName_3, "");
                    _builder_2.append("(\"");
                    String _simpleName_4 = method.getSimpleName();
                    _builder_2.append(_simpleName_4, "");
                    _builder_2.append("\", new Class[]{");
                    Iterable _parameters_1 = method.getParameters();
                    Functions.Function1 _function_1 = it_1 -> {
                        TypeReference _type = it_1.getType();
                        Type _type_1 = _type.getType();
                        String _simpleName_5 = _type_1.getSimpleName();
                        return _simpleName_5 + ".class";
                    };
                    String _join = IterableExtensions.join((Iterable)_parameters_1, (CharSequence)", ", (Functions.Function1)_function_1);
                    _builder_2.append(_join, "");
                    _builder_2.append("}, new Object[]{");
                    Iterable _parameters_2 = method.getParameters();
                    Functions.Function1 _function_2 = it_1 -> it_1.getSimpleName();
                    String _join_1 = IterableExtensions.join((Iterable)_parameters_2, (CharSequence)", ", (Functions.Function1)_function_2);
                    _builder_2.append(_join_1, "");
                    _builder_2.append("})");
                    _switchResult = _builder_2;
                }
            }
            if (!_matched) {
                throw new IllegalArgumentException("delegate signature");
            }
            return _switchResult;
        }

        public String returnIfNeeded(ResolvedMethod it) {
            String _xifexpression = null;
            TypeReference _resolvedReturnType = it.getResolvedReturnType();
            boolean _isVoid = _resolvedReturnType.isVoid();
            _xifexpression = _isVoid ? "" : "return ";
            return _xifexpression;
        }

        public boolean isValidDelegate(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._isValidDelegate((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._isValidDelegate((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public TypeReference getType(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._getType((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._getType((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public CharSequence delegateAccess(MemberDeclaration it, MethodDeclaration method) {
            if (it instanceof MethodDeclaration) {
                return this._delegateAccess((MethodDeclaration)it, method);
            }
            if (it instanceof FieldDeclaration) {
                return this._delegateAccess((FieldDeclaration)it, method);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, method).toString());
        }
    }
}

