/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.base.Function;
import org.eclipse.xtext.validation.Issue;

public class IssueFormatter
implements Function<Issue, String> {
    private final CharSequence document;
    private final boolean showSeverity;

    public IssueFormatter(CharSequence document, boolean showSeverity) {
        this.document = document;
        this.showSeverity = showSeverity;
    }

    public String apply(Issue issue) {
        if (issue == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        if (this.showSeverity) {
            result.append(issue.getSeverity().name());
            result.append(" ");
        }
        result.append('\"');
        result.append(issue.getMessage());
        result.append('\"');
        result.append(" at \"");
        result.append(this.getIssueLocationText(issue));
        result.append("\"");
        return result.toString();
    }

    public CharSequence getDocument() {
        return this.document;
    }

    protected String getIssueLocationText(Issue issue) {
        Integer offset = issue.getOffset();
        Integer length = issue.getLength();
        if (offset == null) {
            return "(offset is null)";
        }
        if (length == null) {
            return "(length is null)";
        }
        String markertext = this.document.subSequence(offset, offset + length).toString();
        return markertext.replace('\n', ' ').replace('\r', ' ');
    }

    public boolean isShowSeverity() {
        return this.showSeverity;
    }
}

