/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;

public class InMemoryFileSystemAccessFormatter
implements Function<InMemoryFileSystemAccess, String> {
    protected boolean alwaysShowFileName = false;
    protected String includeOnlyFileNamesEndingWith = null;

    public InMemoryFileSystemAccessFormatter alwaysShowFileName() {
        this.alwaysShowFileName = true;
        return this;
    }

    public String apply(InMemoryFileSystemAccess fsa) {
        return this.apply(fsa.getAllFiles());
    }

    public String apply(Map<String, Object> files) {
        Map<String, Object> filtered = this.filter(files);
        if (filtered.isEmpty()) {
            return "(no files have been generated)";
        }
        if (filtered.size() == 1 && !this.alwaysShowFileName) {
            return this.formatContent(filtered.values().iterator().next());
        }
        List<Map.Entry<String, Object>> sorted = this.sort(Lists.newArrayList(filtered.entrySet()));
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, Object> e : sorted) {
            StringBuilder buf = new StringBuilder();
            buf.append("-- ");
            buf.append(e.getKey());
            buf.append(" --\n  ");
            buf.append(this.formatContent(e.getValue()).replace("\n", "\n  "));
            buf.append("\n-- / --");
            result.add(buf.toString());
        }
        return Joiner.on((String)"\n").join((Iterable)result);
    }

    protected Map<String, Object> filter(Map<String, Object> files) {
        HashMap filtered = Maps.newHashMap();
        for (Map.Entry<String, Object> e : files.entrySet()) {
            if (!this.isFileNameIncluded(e.getKey())) continue;
            filtered.put(e.getKey(), e.getValue());
        }
        return filtered;
    }

    protected String formatContent(byte[] content) {
        return "(binary content)";
    }

    protected String formatContent(CharSequence content) {
        return content.toString();
    }

    protected String formatContent(Object content) {
        if (content instanceof CharSequence) {
            return this.formatContent((CharSequence)content);
        }
        if (content instanceof byte[]) {
            return this.formatContent((byte[])content);
        }
        if (content != null) {
            return "(unknown content type: " + content.getClass().getName();
        }
        return "(null)";
    }

    public String getIncludeOnlyFileNamesEndingWith() {
        return this.includeOnlyFileNamesEndingWith;
    }

    public InMemoryFileSystemAccessFormatter includeOnlyFileNamesEndingWith(String includeOnlyFileNamesEndingWith) {
        this.includeOnlyFileNamesEndingWith = includeOnlyFileNamesEndingWith;
        return this;
    }

    public boolean isAlwaysShowFileName() {
        return this.alwaysShowFileName;
    }

    protected boolean isFileNameIncluded(String fileName) {
        if (this.includeOnlyFileNamesEndingWith != null && fileName != null) {
            return fileName.endsWith(this.includeOnlyFileNamesEndingWith);
        }
        return true;
    }

    protected List<Map.Entry<String, Object>> sort(List<Map.Entry<String, Object>> files) {
        Collections.sort(files, new FileEntryComparator());
        return files;
    }

    protected static class FileEntryComparator
    implements Comparator<Map.Entry<String, Object>> {
        protected FileEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
            if (o1.getKey() == null) {
                return 1;
            }
            if (o2.getKey() == null) {
                return -1;
            }
            return o1.getKey().compareTo(o2.getKey());
        }
    }
}

