/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.base.Function;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class IResourceFormatter
implements Function<IResource, String> {
    public String format(IResource input) {
        if (input instanceof IContainer) {
            return this.format((IContainer)input);
        }
        if (input != null) {
            return String.valueOf(input.getClass().getSimpleName()) + " " + input.getName();
        }
        return "null";
    }

    protected String format(IContainer container) {
        StringBuilder builder = new StringBuilder();
        builder.append(container.getClass().getSimpleName());
        builder.append(" ");
        builder.append(container.getName());
        builder.append(" {");
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                builder.append("\n  ");
                builder.append(this.format(member).replace("\n", "\n  "));
                ++n2;
            }
        }
        catch (CoreException e) {
            builder.append("Error while calling container.members():" + e.getMessage());
        }
        builder.append("\n}");
        return builder.toString();
    }

    public String apply(IResource input) {
        return this.format(input);
    }

    public String formatWorkspace() {
        return this.format((IContainer)ResourcesPlugin.getWorkspace().getRoot());
    }
}

