/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;

@XpectSetupFactory
@XpectSetupRoot
@XpectImport(value={IgnoredIssues.class, SyntaxAndLinkingAndValidationIssues.class, LinkingAndValidationIssues.class, ValidationErrorsAndWarnings.class, ValidationWarnings.class})
public class ValidationTestConfig {
    private IgnoredIssues ignoredIssues = null;

    public ValidationTestConfig(ISetupInitializer<ValidationTestConfig> init) {
        init.initialize((Object)this);
    }

    public void add(IgnoredIssues ignored) {
        Preconditions.checkArgument((this.ignoredIssues == null ? 1 : 0) != 0, (Object)"ignoredIssues can only be set once.");
        this.ignoredIssues = ignored;
    }

    public Predicate<Issue> getIgnoreFilter() {
        if (this.ignoredIssues == null) {
            return Predicates.alwaysTrue();
        }
        return this.ignoredIssues;
    }

    @Creates
    public ValidationTestConfig getThis() {
        return this;
    }

    @XpectSetupComponent
    public static class IgnoredIssues
    implements Predicate<Issue> {
        private List<IssueFilter> filters = Lists.newArrayList();

        public void add(IssueFilter filter) {
            this.filters.add(filter);
        }

        public boolean apply(Issue input) {
            for (IssueFilter filter : this.filters) {
                if (!filter.shouldIgnore(input)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface IssueFilter {
        public boolean shouldIgnore(Issue var1);
    }

    @XpectSetupComponent
    public static class LinkingAndValidationIssues
    implements IssueFilter {
        @Override
        public boolean shouldIgnore(Issue issue) {
            return !"org.eclipse.xtext.diagnostics.Diagnostic.Syntax".equals(issue.getCode());
        }
    }

    @XpectSetupComponent
    public static class SyntaxAndLinkingAndValidationIssues
    implements IssueFilter {
        @Override
        public boolean shouldIgnore(Issue issue) {
            return true;
        }
    }

    @XpectSetupComponent
    public static class ValidationErrorsAndWarnings
    implements IssueFilter {
        @Override
        public boolean shouldIgnore(Issue issue) {
            return !"org.eclipse.xtext.diagnostics.Diagnostic.Syntax".equals(issue.getCode()) && !"org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issue.getCode());
        }
    }

    @XpectSetupComponent
    public static class ValidationWarnings
    implements IssueFilter {
        @Override
        public boolean shouldIgnore(Issue issue) {
            return issue.getSeverity() == Severity.WARNING;
        }
    }
}

