/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.adapter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vorto.model.BooleanAttributeProperty;
import org.eclipse.vorto.model.BooleanAttributePropertyType;
import org.eclipse.vorto.model.DictionaryType;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.EnumAttributePropertyType;
import org.eclipse.vorto.model.EnumLiteral;
import org.eclipse.vorto.model.EnumModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.Infomodel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.model.PrimitiveType;

public class ObjectMapperFactory {
    private static ObjectMapper mapper = null;

    public static ObjectMapper getInstance(ObjectMapper existingMapper) {
        if (mapper == null) {
            mapper = existingMapper != null ? existingMapper : new ObjectMapper();
            ObjectMapperFactory.init(mapper);
        }
        return mapper;
    }

    public static ObjectMapper getInstance() {
        return ObjectMapperFactory.getInstance(null);
    }

    private static void init(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(IPropertyAttribute.class, (JsonDeserializer)new PropertyAttributeDeserializer());
        module.addDeserializer(IReferenceType.class, (JsonDeserializer)new ModelReferenceDeserializer());
        module.addDeserializer(IModel.class, (JsonDeserializer)new ModelDeserializer());
        module.addDeserializer(Map.class, (JsonDeserializer)new ModelMapDeserializer());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)module);
    }

    public static class ModelDeserializer
    extends StdDeserializer<IModel> {
        public ModelDeserializer() {
            this(null);
        }

        public ModelDeserializer(Class<?> vc) {
            super(vc);
        }

        public IModel deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                ObjectCodec oc = parser.getCodec();
                JsonNode node = (JsonNode)oc.readTree(parser);
                JsonNode type = node.get("type");
                if (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.InformationModel)) {
                    return (IModel)oc.treeToValue((TreeNode)node, Infomodel.class);
                }
                if (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Functionblock)) {
                    return (IModel)oc.treeToValue((TreeNode)node, FunctionblockModel.class);
                }
                if (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Datatype) && node.has("literals")) {
                    return (IModel)oc.treeToValue((TreeNode)node, EnumModel.class);
                }
                return (IModel)oc.treeToValue((TreeNode)node, EntityModel.class);
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
        }
    }

    public static class ModelReferenceDeserializer
    extends StdDeserializer<IReferenceType> {
        public ModelReferenceDeserializer() {
            this(null);
        }

        public ModelReferenceDeserializer(Class<?> vc) {
            super(vc);
        }

        public IReferenceType deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            if (node.has("type")) {
                JsonNode type = node.get("type");
                if (type.asText().equals("dictionary")) {
                    return (IReferenceType)oc.treeToValue((TreeNode)node, DictionaryType.class);
                }
                if (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Functionblock)) {
                    return (IReferenceType)oc.treeToValue((TreeNode)node, FunctionblockModel.class);
                }
                return node.has("literals") ? (IReferenceType)oc.treeToValue((TreeNode)node, EnumModel.class) : (IReferenceType)oc.treeToValue((TreeNode)node, EntityModel.class);
            }
            if (node.has("namespace")) {
                return (IReferenceType)oc.treeToValue((TreeNode)node, ModelId.class);
            }
            return (IReferenceType)oc.treeToValue((TreeNode)node, PrimitiveType.class);
        }
    }

    public static class PropertyAttributeDeserializer
    extends StdDeserializer<IPropertyAttribute> {
        public PropertyAttributeDeserializer() {
            this(null);
        }

        public PropertyAttributeDeserializer(Class<?> vc) {
            super(vc);
        }

        public IPropertyAttribute deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            JsonNode value = node.get("value");
            if (value.isBoolean()) {
                BooleanAttributeProperty booleanAttribute = new BooleanAttributeProperty();
                booleanAttribute.setType(BooleanAttributePropertyType.valueOf((String)node.get("type").asText()));
                booleanAttribute.setValue(value.asBoolean());
                return booleanAttribute;
            }
            EnumAttributeProperty enumAttribute = new EnumAttributeProperty();
            enumAttribute.setType(EnumAttributePropertyType.MEASUREMENT_UNIT);
            ModelId parent = new ModelId(value.get("parent").get("name").asText(), value.get("parent").get("namespace").asText(), value.get("parent").get("version").asText());
            EnumLiteral literal = new EnumLiteral(value.get("name").asText(), value.get("description").asText(), parent);
            enumAttribute.setValue(literal);
            return enumAttribute;
        }
    }

    public static class ModelMapDeserializer
    extends StdDeserializer<Map<Object, Object>> {
        public ModelMapDeserializer() {
            this(null);
        }

        public ModelMapDeserializer(Class<?> vc) {
            super(vc);
        }

        public Map<Object, Object> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            try {
                JsonNode childNode;
                JsonNode type;
                HashMap<Object, Object> deserialized = new HashMap<Object, Object>();
                ObjectCodec oc = parser.getCodec();
                JsonNode node = (JsonNode)oc.readTree(parser);
                Iterator iterator = node.elements();
                while (iterator.hasNext() && (type = (childNode = (JsonNode)iterator.next()).get("type")) != null) {
                    IModel value = null;
                    value = ModelType.valueOf((String)type.asText()).equals((Object)ModelType.InformationModel) ? (IModel)oc.treeToValue((TreeNode)childNode, Infomodel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Functionblock) ? (IModel)oc.treeToValue((TreeNode)childNode, FunctionblockModel.class) : (ModelType.valueOf((String)type.asText()).equals((Object)ModelType.Datatype) && childNode.has("literals") ? (IModel)oc.treeToValue((TreeNode)childNode, EnumModel.class) : (IModel)oc.treeToValue((TreeNode)childNode, EntityModel.class)));
                    if (value == null) continue;
                    deserialized.put(this.getModelId(childNode.get("id").get("prettyFormat").asText()), value);
                }
                if (deserialized.isEmpty()) {
                    Iterator fieldsIter = node.fieldNames();
                    while (fieldsIter.hasNext()) {
                        String field = (String)fieldsIter.next();
                        deserialized.put(field, node.get(field).asText());
                    }
                }
                return deserialized;
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
        }

        private ModelId getModelId(String modelId) {
            try {
                return ModelId.fromPrettyFormat((String)modelId);
            }
            catch (IllegalArgumentException ex) {
                int versionIndex = modelId.indexOf(":");
                return ModelId.fromReference((String)modelId.substring(0, versionIndex), (String)modelId.substring(versionIndex + 1));
            }
        }
    }
}

