/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import java.util.Arrays;
import java.util.Objects;

public interface EnumUtil {
    public static <E extends Enum<E>> boolean isAnyValueOfCaseInsensitive(Class<E> clazz, String value) {
        return Objects.nonNull(value) && Arrays.stream(clazz.getEnumConstants()).anyMatch(v -> v.name().equalsIgnoreCase(value));
    }

    public static <E extends Enum<E>> String forNameIgnoreCase(Class<E> clazz, String value) {
        if (Objects.nonNull(value)) {
            return Arrays.stream(clazz.getEnumConstants()).filter(v -> v.name().equalsIgnoreCase(value)).findAny().map(Enum::name).orElse(value);
        }
        return null;
    }
}

