/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import org.eclipse.vorto.model.AbstractProperty;
import org.eclipse.vorto.model.Constraint;
import org.eclipse.vorto.model.ConstraintType;
import org.eclipse.vorto.model.IReferenceType;

public class Param
extends AbstractProperty {
    public static Builder Builder(String name, IReferenceType type) {
        return new Builder(name, type);
    }

    public String toString() {
        return "Param [isMandatory=" + this.mandatory + ", name=" + this.name + ", isMultiple=" + this.isMultiple + ", description=" + this.description + ", type=" + this.type + ", constraints=" + this.constraints + "]";
    }

    public static class Builder {
        private Param param = new Param();

        public Builder(String name, IReferenceType type) {
            this.param.setMandatory(true);
            this.param.setName(name);
            this.param.setType(type);
        }

        public Builder optional() {
            this.param.setMandatory(false);
            return this;
        }

        public Builder multiple() {
            this.param.setMultiple(true);
            return this;
        }

        public Builder withConstraint(ConstraintType type, String value) {
            this.param.getConstraints().add(new Constraint(type, value));
            return this;
        }

        public Param build() {
            return this.param;
        }
    }
}

