/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.vorto.model.AbstractProperty;
import org.eclipse.vorto.model.Constraint;
import org.eclipse.vorto.model.ConstraintType;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.EnumAttributePropertyType;
import org.eclipse.vorto.model.EnumLiteral;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.PrimitiveType;
import org.eclipse.vorto.model.Stereotype;

public class ModelProperty
extends AbstractProperty {
    private List<IPropertyAttribute> attributes = new ArrayList<IPropertyAttribute>();

    public static ModelProperty createPrimitiveProperty(String name, boolean isMandatory, PrimitiveType type) {
        ModelProperty property = new ModelProperty();
        property.setName(name);
        property.setType(type);
        property.setMandatory(isMandatory);
        return property;
    }

    public static Builder Builder(String name, IReferenceType type) {
        return new Builder(name, type);
    }

    public List<IPropertyAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<IPropertyAttribute> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        return "ModelProperty [attributes=" + this.attributes + ", isMandatory=" + this.mandatory + ", name=" + this.name + ", isMultiple=" + this.isMultiple + ", description=" + this.description + ", type=" + this.type + ", constraints=" + this.constraints + "]";
    }

    public static class Builder {
        private ModelProperty property = new ModelProperty();

        public Builder(String name, IReferenceType type) {
            this.property.setMandatory(true);
            this.property.setName(name);
            this.property.setType(type);
        }

        public Builder optional() {
            this.property.setMandatory(false);
            return this;
        }

        public Builder multiple() {
            this.property.setMultiple(true);
            return this;
        }

        public Builder withConstraint(ConstraintType type, String value) {
            this.property.getConstraints().add(new Constraint(type, value));
            return this;
        }

        public Builder withAttributeMeasurementUnit(EnumLiteral literal) {
            this.property.getAttributes().add(new EnumAttributeProperty(EnumAttributePropertyType.MEASUREMENT_UNIT, literal));
            return this;
        }

        public Builder withStereotype(String stereoTypeName, Map<String, String> attributes, String targetPlatformKey) {
            this.property.setTargetPlatformKey(targetPlatformKey);
            this.property.addStereotype(Stereotype.create(stereoTypeName, attributes));
            return this;
        }

        public Builder withXPathStereotype(String xpathValue, String targetPlatformKey) {
            this.property.setTargetPlatformKey(targetPlatformKey);
            this.property.addStereotype(Stereotype.createWithXpath(xpathValue));
            return this;
        }

        public Builder withMappingReference(ModelId referenceId) {
            this.property.setMappingReference(referenceId);
            return this;
        }

        public ModelProperty build() {
            return this.property;
        }
    }
}

