/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.EntityMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.FunctionblockMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.IMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.InformationModelMappingSerializer;
import org.eclipse.vorto.mapping.engine.serializer.MappingIdUtils;
import org.eclipse.vorto.model.EntityModel;
import org.eclipse.vorto.model.FunctionblockModel;
import org.eclipse.vorto.model.IModel;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;

public class MappingSpecificationSerializer {
    private IMappingSpecification specification;
    private String targetPlatform;

    private MappingSpecificationSerializer(IMappingSpecification specification, String targetPlatform) {
        this.specification = specification;
        this.targetPlatform = targetPlatform;
    }

    public static MappingSpecificationSerializer create(IMappingSpecification specification, String targetPlaform) {
        return new MappingSpecificationSerializer(specification, targetPlaform);
    }

    public static MappingSpecificationSerializer create(IMappingSpecification specification) {
        return MappingSpecificationSerializer.create(specification, specification.getInfoModel().getTargetPlatformKey());
    }

    public Iterator<IMappingSerializer> iterator() {
        ModelId rootMappingId = MappingIdUtils.getIdForInfoModel(this.specification.getInfoModel());
        ArrayList<IMappingSerializer> serializers = new ArrayList<IMappingSerializer>();
        for (ModelProperty fbProperty : this.specification.getInfoModel().getFunctionblocks()) {
            FunctionblockModel fbm = this.specification.getFunctionBlock(fbProperty.getName());
            ModelId mappingId = MappingIdUtils.getIdForProperty(rootMappingId, fbProperty);
            this.addSerializerRecursive(mappingId, (IModel)fbm, fbm.getProperties(), serializers);
            serializers.add(new FunctionblockMappingSerializer(this.specification, mappingId, this.targetPlatform, fbProperty.getName()));
        }
        serializers.add(new InformationModelMappingSerializer(this.specification, rootMappingId, this.targetPlatform));
        return serializers.iterator();
    }

    private void addSerializerRecursive(ModelId parentId, IModel container, List<ModelProperty> properties, List<IMappingSerializer> serializers) {
        for (ModelProperty property : properties) {
            if (!this.isEntityProperty(property)) continue;
            EntityModel entityModel = (EntityModel)property.getType();
            ModelId mappingId = MappingIdUtils.getIdForProperty(parentId, property);
            this.addSerializerRecursive(mappingId, (IModel)entityModel, entityModel.getProperties(), serializers);
            serializers.add(new EntityMappingSerializer(this.specification, mappingId, this.targetPlatform, property.getName(), entityModel));
        }
    }

    private boolean isEntityProperty(ModelProperty property) {
        return property.getType() instanceof EntityModel;
    }
}

