/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.mapping.engine.spec.IMappingSpecification;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.content.FunctionblockModel;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Operation;
import org.eclipse.vorto.repository.api.content.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FunctionblockMappingSerializer
extends AbstractSerializer {
    private String propertyName;
    private FunctionblockModel fbm;

    public FunctionblockMappingSerializer(IMappingSpecification spec, String targetPlaform, String propertyName) {
        super(spec, targetPlaform);
        FunctionblockModel _functionBlock;
        this.propertyName = propertyName;
        this.fbm = _functionBlock = spec.getFunctionBlock(propertyName);
    }

    @Override
    public String serialize() {
        FunctionblockModel _functionBlock_1;
        Optional _stereotype_1;
        Stereotype _get;
        Map _attributes;
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace ");
        Infomodel _infoModel = this.specification.getInfoModel();
        ModelId _id = _infoModel.getId();
        String _namespace = _id.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)".mapping");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"");
        _builder.append((Object)this.propertyName, "");
        _builder.append((Object)"PayloadMapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"description \"");
        String _lowerCase = this.targetPlatform.toLowerCase();
        String _firstUpper = StringExtensions.toFirstUpper((String)_lowerCase);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)" Payload Mapping for the ");
        _builder.append((Object)this.propertyName, "");
        _builder.append((Object)" property of the ");
        Infomodel _infoModel_1 = this.specification.getInfoModel();
        String _displayName = _infoModel_1.getDisplayName();
        _builder.append((Object)_displayName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"using ");
        ModelId _id_1 = this.fbm.getId();
        String _namespace_1 = _id_1.getNamespace();
        _builder.append((Object)_namespace_1, "");
        _builder.append((Object)".");
        ModelId _id_2 = this.fbm.getId();
        String _name = _id_2.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        ModelId _id_3 = this.fbm.getId();
        String _version = _id_3.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"functionblockmapping ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)this.propertyName);
        _builder.append((Object)_firstUpper_1, "");
        _builder.append((Object)"PayloadMapping");
        String _lowerCase_1 = this.targetPlatform.toLowerCase();
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_lowerCase_1);
        _builder.append((Object)_firstUpper_2, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetplatform ");
        _builder.append((Object)this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        FunctionblockModel _functionBlock = this.specification.getFunctionBlock(this.propertyName);
        Optional _stereotype = _functionBlock.getStereotype("functions");
        boolean _isPresent = _stereotype.isPresent();
        _and = !_isPresent ? false : (_not = !(_isEmpty = (_attributes = (_get = (Stereotype)(_stereotype_1 = (_functionBlock_1 = this.specification.getFunctionBlock(this.propertyName)).getStereotype("functions")).get()).getAttributes()).isEmpty()));
        if (_and) {
            _builder.append((Object)"\t");
            _builder.append((Object)"from ");
            ModelId _id_4 = this.fbm.getId();
            String _name_1 = _id_4.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)" to functions with {");
            FunctionblockModel _functionBlock_2 = this.specification.getFunctionBlock(this.propertyName);
            Optional _stereotype_2 = _functionBlock_2.getStereotype("functions");
            Stereotype _get_1 = (Stereotype)_stereotype_2.get();
            String _createFunctions = this.createFunctions(_get_1);
            _builder.append((Object)_createFunctions, "\t");
            _builder.append((Object)"}");
            _builder.newLineIfNotEmpty();
        }
        FunctionblockModel _functionBlock_3 = this.specification.getFunctionBlock(this.propertyName);
        List _stereotypes = _functionBlock_3.getStereotypes();
        for (Stereotype stereotype : _stereotypes) {
            String _name_2 = stereotype.getName();
            boolean _equalsIgnoreCase = _name_2.equalsIgnoreCase("functions");
            boolean _not_1 = !_equalsIgnoreCase;
            if (!_not_1) continue;
            _builder.append((Object)"\t");
            _builder.append((Object)"from ");
            ModelId _id_5 = this.fbm.getId();
            String _name_3 = _id_5.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)" to ");
            String _name_4 = stereotype.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)" with {");
            Map _attributes_1 = stereotype.getAttributes();
            String _createContent = this.createContent(_attributes_1);
            _builder.append((Object)_createContent, "\t");
            _builder.append((Object)"}");
            _builder.newLineIfNotEmpty();
        }
        List _statusProperties = this.fbm.getStatusProperties();
        for (ModelProperty statusProperty : _statusProperties) {
            List _stereotypes_1 = statusProperty.getStereotypes();
            List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(_stereotypes_1);
            for (Stereotype stereotype_1 : _filterEmptyStereotypes) {
                _builder.append((Object)"\t");
                _builder.append((Object)"from ");
                ModelId _id_6 = this.fbm.getId();
                String _name_5 = _id_6.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append((Object)".status.");
                String _name_6 = statusProperty.getName();
                _builder.append((Object)_name_6, "\t");
                _builder.append((Object)" to ");
                String _name_7 = stereotype_1.getName();
                _builder.append((Object)_name_7, "\t");
                _builder.append((Object)" with {");
                Map _attributes_2 = stereotype_1.getAttributes();
                String _createContent_1 = this.createContent(_attributes_2);
                _builder.append((Object)_createContent_1, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
        }
        List _configurationProperties = this.fbm.getConfigurationProperties();
        for (ModelProperty configProperty : _configurationProperties) {
            List _stereotypes_2 = configProperty.getStereotypes();
            List<Stereotype> _filterEmptyStereotypes_1 = this.filterEmptyStereotypes(_stereotypes_2);
            for (Stereotype stereotype_2 : _filterEmptyStereotypes_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"from ");
                ModelId _id_7 = this.fbm.getId();
                String _name_8 = _id_7.getName();
                _builder.append((Object)_name_8, "\t");
                _builder.append((Object)".configuration.");
                String _name_9 = configProperty.getName();
                _builder.append((Object)_name_9, "\t");
                _builder.append((Object)" to ");
                String _name_10 = stereotype_2.getName();
                _builder.append((Object)_name_10, "\t");
                _builder.append((Object)" with {");
                Map _attributes_3 = stereotype_2.getAttributes();
                String _createContent_2 = this.createContent(_attributes_3);
                _builder.append((Object)_createContent_2, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
        }
        List _operations = this.fbm.getOperations();
        for (Operation operation : _operations) {
            List _stereotypes_3 = operation.getStereotypes();
            List<Stereotype> _filterEmptyStereotypes_2 = this.filterEmptyStereotypes(_stereotypes_3);
            for (Stereotype stereotype_3 : _filterEmptyStereotypes_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"from ");
                ModelId _id_8 = this.fbm.getId();
                String _name_11 = _id_8.getName();
                _builder.append((Object)_name_11, "\t");
                _builder.append((Object)".operations.");
                String _name_12 = operation.getName();
                _builder.append((Object)_name_12, "\t");
                _builder.append((Object)" to ");
                String _name_13 = stereotype_3.getName();
                _builder.append((Object)_name_13, "\t");
                _builder.append((Object)" with {");
                Map _attributes_4 = stereotype_3.getAttributes();
                String _createContent_3 = this.createContent(_attributes_4);
                _builder.append((Object)_createContent_3, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String createFunctions(Stereotype functionsStereotype) {
        StringBuilder content = new StringBuilder();
        Iterator iter = functionsStereotype.getAttributes().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            boolean _equals = "_namespace".equals(key);
            boolean _not = !_equals;
            if (!_not) continue;
            StringBuilder _append = content.append(key);
            StringBuilder _append_1 = _append.append(":");
            Map _attributes = functionsStereotype.getAttributes();
            String _get = (String)_attributes.get(key);
            String _escapeQuotes = this.escapeQuotes(_get);
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append_1.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Stream _stream = stereotypes.stream();
        Predicate<Stereotype> _function = it -> {
            Map _attributes = it.getAttributes();
            boolean _isEmpty = _attributes.isEmpty();
            return !_isEmpty;
        };
        Stream<Stereotype> _filter = _stream.filter(_function);
        Predicate<Stereotype> _function_1 = it -> {
            Map _attributes = it.getAttributes();
            HashMap<String, String> _nonEmptyAttributes = this.getNonEmptyAttributes(_attributes);
            boolean _isEmpty = _nonEmptyAttributes.isEmpty();
            return !_isEmpty;
        };
        Stream<Stereotype> _filter_1 = _filter.filter(_function_1);
        Collector _list = Collectors.toList();
        return _filter_1.collect(_list);
    }

    private HashMap<String, String> getNonEmptyAttributes(Map<String, String> attributes) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set<String> _keySet = attributes.keySet();
        for (String key : _keySet) {
            String _get = attributes.get(key);
            boolean _isEmpty = _get.isEmpty();
            boolean _not = !_isEmpty;
            if (!_not) continue;
            String _get_1 = attributes.get(key);
            newMap.put(key, _get_1);
        }
        return newMap;
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            boolean _equalsIgnoreCase_1;
            String key = iter.next();
            boolean _and = false;
            boolean _or = false;
            boolean _equalsIgnoreCase = key.equalsIgnoreCase("xpath");
            _or = _equalsIgnoreCase ? true : (_equalsIgnoreCase_1 = key.equalsIgnoreCase("condition"));
            if (!_or) {
                _and = false;
            } else {
                boolean _equals;
                String _get = attributes.get(key);
                _and = _equals = _get.equals("");
            }
            if (_and) continue;
            StringBuilder _append = content.append(key);
            StringBuilder _append_1 = _append.append(":");
            String _get_1 = attributes.get(key);
            String _escapeQuotes = this.escapeQuotes(_get_1);
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append_1.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    @Override
    public ModelId getModelId() {
        String _firstUpper = StringExtensions.toFirstUpper((String)this.propertyName);
        String _plus = _firstUpper + "PayloadMapping";
        String _lowerCase = this.targetPlatform.toLowerCase();
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)_lowerCase);
        String _plus_1 = _plus + _firstUpper_1;
        Infomodel _infoModel = this.specification.getInfoModel();
        ModelId _id = _infoModel.getId();
        String _namespace = _id.getNamespace();
        String _plus_2 = _namespace + ".mapping";
        return new ModelId(_plus_1, _plus_2, "1.0.0");
    }
}

