/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorInfo;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.api.VortoCodeGeneratorException;
import org.eclipse.vorto.codegen.hono.java.AppTemplate;
import org.eclipse.vorto.codegen.hono.java.CertificateTemplate;
import org.eclipse.vorto.codegen.hono.java.Log4jTemplate;
import org.eclipse.vorto.codegen.hono.java.PomFileTemplate;
import org.eclipse.vorto.codegen.hono.java.model.FunctionblockTemplate;
import org.eclipse.vorto.codegen.hono.java.model.InformationModelTemplate;
import org.eclipse.vorto.codegen.hono.java.model.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.model.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.hono.java.service.IDataServiceTemplate;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoDataService;
import org.eclipse.vorto.codegen.hono.java.service.hono.HonoMqttClientTemplate;
import org.eclipse.vorto.codegen.utils.GenerationResultBuilder;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class EclipseHonoJavaGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel model, InvocationContext context, IVortoCodeGenProgressMonitor monitor) throws VortoCodeGeneratorException {
        GenerationResultZip output = new GenerationResultZip(model, this.getServiceKey());
        GenerationResultBuilder result = GenerationResultBuilder.from((IGenerationResult)output);
        result.append(this.generateJava(model, context, monitor));
        return output;
    }

    private IGenerationResult generateJava(InformationModel infomodel, InvocationContext context, IVortoCodeGenProgressMonitor monitor) {
        GenerationResultZip output = new GenerationResultZip(infomodel, this.getServiceKey());
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new PomFileTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new Log4jTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new CertificateTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AppTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IDataServiceTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new HonoDataService()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new HonoMqttClientTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new InformationModelTemplate()));
        generator.generate((Object)infomodel, context, (IGeneratedWriter)output);
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            new GeneratorTaskFromFileTemplate((IFileTemplate)new FunctionblockTemplate(infomodel)).generate((Object)fbProperty.getType(), context, (IGeneratedWriter)output);
            FunctionBlock fb = fbProperty.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                this.generateForEntity(infomodel, entity, (IGeneratedWriter)output);
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                this.generateForEnum(infomodel, en, (IGeneratedWriter)output);
            }
        }
        return output;
    }

    private void generateForEntity(InformationModel infomodel, Entity entity, IGeneratedWriter outputter) {
        new JavaClassGeneratorTask(infomodel).generate(entity, null, outputter);
    }

    private void generateForEnum(InformationModel infomodel, Enum en, IGeneratedWriter outputter) {
        new JavaEnumGeneratorTask(infomodel).generate(en, null, outputter);
    }

    public String getServiceKey() {
        return "hono-java";
    }

    public GeneratorInfo getInfo() {
        return GeneratorInfo.basicInfo((String)"Eclipse Hono Java Generator", (String)"Generates device java source code that integrates with Eclipse Hono and Eclipse Ditto.", (String)"Eclipse Vorto Team");
    }
}

