/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.hono.java;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.hono.java.TypeMapper;
import org.eclipse.vorto.codegen.hono.java.Utils;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class AppTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"App.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _javaPackageBasePath = Utils.getJavaPackageBasePath(context);
        _builder.append((Object)_javaPackageBasePath, "");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _javaPackage = Utils.getJavaPackage(element);
        _builder.append((Object)_javaPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.apache.log4j.Logger;");
        _builder.newLine();
        _builder.newLine();
        EList _references = element.getReferences();
        for (ModelReference reference : _references) {
            ModelId modelId = ModelIdFactory.newInstance((ModelType)ModelType.Functionblock, (ModelReference)reference);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"import ");
            String _javaPackage_1 = Utils.getJavaPackage(element);
            _builder.append((Object)_javaPackage_1, "");
            _builder.append((Object)".model.");
            String _name = modelId.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"import ");
        String _javaPackage_2 = Utils.getJavaPackage(element);
        _builder.append((Object)_javaPackage_2, "");
        _builder.append((Object)".service.hono.HonoDataService;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Example App that uses the Hono Data Service by sending random data to Eclipse Hono MQTT Connector");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_1 = element.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"App {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final Logger LOGGER = Logger.getLogger(");
        String _name_2 = element.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"App.class);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* Configuration Section */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* Adjust according to your Endpoint Configuration*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Hono MQTT Endpoint");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String MQTT_ENDPOINT = \"");
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("hono_endpoint", "<INSERT HONO MQTT ENDPOINT HERE>");
        _builder.append((Object)_orDefault, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Your Tenant");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String HONO_TENANT = \"");
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("hono_tenant", "DEFAULT_TENANT");
        _builder.append((Object)_orDefault_1, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Your DeviceId");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String DEVICE_ID = \"");
        Map _configurationProperties_2 = context.getConfigurationProperties();
        String _orDefault_2 = _configurationProperties_2.getOrDefault("deviceId", "<INSERT DEVICE ID HERE>");
        _builder.append((Object)_orDefault_2, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Device authentication ID");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String AUTH_ID = \"");
        Map _configurationProperties_3 = context.getConfigurationProperties();
        String _orDefault_3 = _configurationProperties_3.getOrDefault("hono_user", "<INSERT DEVICE AUTH ID HERE>");
        _builder.append((Object)_orDefault_3, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Ditto Namespace");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String DITTO_NAMESPACE = \"");
        Map _configurationProperties_4 = context.getConfigurationProperties();
        String _orDefault_4 = _configurationProperties_4.getOrDefault("ditto_namespace", "com.mycompany");
        _builder.append((Object)_orDefault_4, "\t");
        _builder.append((Object)"\";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Device authentication Password");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final String PASSWORD = \"ENTER_DEVICE_PASSWORD\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static final long SEND_INTERVAL_IN_SECONDS = 2;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static void main(final String... args) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"HonoDataService honoDataService = new HonoDataService(MQTT_ENDPOINT, HONO_TENANT, DITTO_NAMESPACE, ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"DEVICE_ID, AUTH_ID,PASSWORD);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while (true) {");
        _builder.newLine();
        EList _properties = element.getProperties();
        for (FunctionblockProperty fbProperty : _properties) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"honoDataService.publish");
            String _name_3 = fbProperty.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_3);
            _builder.append((Object)_firstUpper, "\t\t\t");
            _builder.append((Object)"(DEVICE_ID,read");
            String _name_4 = fbProperty.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_4);
            _builder.append((Object)_firstUpper_1, "\t\t\t");
            _builder.append((Object)"());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"Thread.sleep(SEND_INTERVAL_IN_SECONDS * 1000);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"LOGGER.error(e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        EList _properties_1 = element.getProperties();
        for (FunctionblockProperty fbProperty_1 : _properties_1) {
            FunctionblockModel _type_6;
            FunctionBlock _functionblock_2;
            Configuration _configuration;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            _builder.append((Object)"\t");
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"* Reads the ");
            String _name_5 = fbProperty_1.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)" from the device");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private static ");
            FunctionblockModel _type = fbProperty_1.getType();
            String _name_6 = _type.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)" read");
            String _name_7 = fbProperty_1.getName();
            String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_7);
            _builder.append((Object)_firstUpper_2, "\t");
            _builder.append((Object)"() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            FunctionblockModel _type_1 = fbProperty_1.getType();
            String _name_8 = _type_1.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)" ");
            String _name_9 = fbProperty_1.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)" = new ");
            FunctionblockModel _type_2 = fbProperty_1.getType();
            String _name_10 = _type_2.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
            FunctionblockModel _type_3 = fbProperty_1.getType();
            FunctionBlock _functionblock = _type_3.getFunctionblock();
            Status _status = _functionblock.getStatus();
            boolean bl = _tripleNotEquals = _status != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"//Status properties");
                _builder.newLine();
                FunctionblockModel _type_4 = fbProperty_1.getType();
                FunctionBlock _functionblock_1 = _type_4.getFunctionblock();
                Status _status_1 = _functionblock_1.getStatus();
                EList _properties_2 = _status_1.getProperties();
                for (Property statusProperty : _properties_2) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _name_11 = fbProperty_1.getName();
                    _builder.append((Object)_name_11, "\t\t");
                    _builder.append((Object)".set");
                    String _name_12 = statusProperty.getName();
                    String _checkKeyword = TypeMapper.checkKeyword(_name_12);
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_checkKeyword);
                    _builder.append((Object)_firstUpper_3, "\t\t");
                    _builder.append((Object)"(");
                    PropertyType _type_5 = statusProperty.getType();
                    String _randomValue = TypeMapper.getRandomValue(_type_5);
                    _builder.append((Object)_randomValue, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
            boolean bl2 = _tripleNotEquals_1 = (_configuration = (_functionblock_2 = (_type_6 = fbProperty_1.getType()).getFunctionblock()).getConfiguration()) != null;
            if (_tripleNotEquals_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"//Configuration properties");
                _builder.newLine();
                FunctionblockModel _type_7 = fbProperty_1.getType();
                FunctionBlock _functionblock_3 = _type_7.getFunctionblock();
                Configuration _configuration_1 = _functionblock_3.getConfiguration();
                EList _properties_3 = _configuration_1.getProperties();
                for (Property configurationProperty : _properties_3) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    String _name_13 = fbProperty_1.getName();
                    _builder.append((Object)_name_13, "\t\t");
                    _builder.append((Object)".set");
                    String _name_14 = configurationProperty.getName();
                    String _checkKeyword_1 = TypeMapper.checkKeyword(_name_14);
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)_checkKeyword_1);
                    _builder.append((Object)_firstUpper_4, "\t\t");
                    _builder.append((Object)"(");
                    PropertyType _type_8 = configurationProperty.getType();
                    String _randomValue_1 = TypeMapper.getRandomValue(_type_8);
                    _builder.append((Object)_randomValue_1, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ");
            String _name_15 = fbProperty_1.getName();
            _builder.append((Object)_name_15, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

