/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.util.ScanResult;
import org.eclipse.tycho.surefire.AbstractTestMojo;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class TestPluginMojo
extends AbstractTestMojo {
    @Parameter(property="project.build.outputDirectory")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports")
    protected File reportsDirectory;
    @Parameter(property="failIfNoTests", defaultValue="true")
    private boolean failIfNoTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;

    @Override
    protected boolean shouldRun() {
        if ("eclipse-plugin".equals(this.project.getPackaging())) {
            return false;
        }
        if (!"eclipse-test-plugin".equals(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)("Unsupported packaging type " + this.project.getPackaging()));
            return false;
        }
        return true;
    }

    @Override
    protected List<String> getDefaultInclude() {
        return Arrays.asList("**/Test*.class", "**/*Test.class", "**/*Tests.class", "**/*TestCase.class");
    }

    @Override
    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    protected File getReportsDirectory() {
        return this.reportsDirectory;
    }

    @Override
    protected PropertiesWrapper createSurefireProperties(TestFrameworkProvider provider, ScanResult scanResult) throws MojoExecutionException {
        PropertiesWrapper properties = super.createSurefireProperties(provider, scanResult);
        properties.setProperty("failifnotests", String.valueOf(this.failIfNoTests));
        return properties;
    }

    @Override
    protected void handleNoTestsFound() throws MojoFailureException {
        String message = "No tests found.";
        if (this.failIfNoTests) {
            throw new MojoFailureException(message);
        }
        this.getLog().warn((CharSequence)message);
    }

    @Override
    protected void handleSuccess() {
        this.getLog().info((CharSequence)"All tests passed!");
    }

    @Override
    protected void handleTestFailures() throws MojoFailureException {
        String errorMessage = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
        if (!this.testFailureIgnore) {
            throw new MojoFailureException(errorMessage);
        }
        this.getLog().error((CharSequence)errorMessage);
    }
}

