/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.reverseresolve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.shared.DependencyResolutionException;
import org.eclipse.tycho.packaging.reverseresolve.ArtifactCoordinateResolver;

@Component(role=ArtifactCoordinateResolver.class, hint="local")
public class RepositoryArtifactCoordinateResolver
implements ArtifactCoordinateResolver {
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private Logger log;

    @Override
    public Optional<Dependency> resolve(Path path) {
        MavenSession session = this.legacySupport.getSession();
        if (session != null) {
            try {
                Properties properties = RepositoryArtifactCoordinateResolver.getArtifactProperties(path);
                if (properties == null) {
                    return Optional.empty();
                }
                String artifactId = properties.getProperty("artifactId");
                String groupId = properties.getProperty("groupId");
                String version = properties.getProperty("version");
                if (artifactId != null && groupId != null && version != null) {
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(groupId);
                    dependency.setArtifactId(artifactId);
                    dependency.setType(FilenameUtils.getExtension((String)path.getFileName().toString()));
                    dependency.setVersion(version);
                    Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
                    ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                    request.setArtifact(artifact);
                    request.setOffline(session.isOffline());
                    request.setLocalRepository(session.getLocalRepository());
                    this.repositorySystem.injectMirror(request.getRemoteRepositories(), session.getSettings().getMirrors());
                    this.repositorySystem.injectProxy(request.getRemoteRepositories(), session.getSettings().getProxies());
                    this.repositorySystem.injectAuthentication(request.getRemoteRepositories(), session.getSettings().getServers());
                    ArtifactResolutionResult resolveResult = this.repositorySystem.resolve(request);
                    if (resolveResult.hasExceptions()) {
                        DependencyResolutionException exception = new DependencyResolutionException("resolving " + artifact + " failed!", (Collection)resolveResult.getExceptions());
                        this.log.debug("Resolve " + artifact + " failed because of " + exception, (Throwable)exception);
                        return Optional.empty();
                    }
                    return resolveResult.getArtifacts().stream().filter(a -> a.getFile() != null).filter(a -> {
                        try {
                            return FileUtils.contentEquals((File)a.getFile(), (File)path.toFile());
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }).map(a -> {
                        Dependency result = new Dependency();
                        result.setGroupId(a.getGroupId());
                        result.setArtifactId(a.getArtifactId());
                        result.setVersion(a.getVersion());
                        result.setType(a.getType());
                        return result;
                    }).findFirst();
                }
            }
            catch (Exception e) {
                this.log.debug("Can't process " + path + " because of " + e, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties getArtifactProperties(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                Properties properties;
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
                InputStream stream = jarFile.getInputStream(jarEntry);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(stream);
                    properties = properties2;
                    if (stream == null) return properties;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                stream.close();
                return properties;
            }
        }
    }
}

