/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging.osgiresolve;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.eclipse.tycho.packaging.osgiresolve.FileConnectEntry;
import org.eclipse.tycho.packaging.osgiresolve.ZipConnectEntry;
import org.osgi.framework.Version;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectModule;

public class TestModule
implements ConnectContent,
ConnectModule {
    private Map<String, String> headers;
    private File location;
    private JarFile jarFile;
    private String name;
    private Version version;

    public TestModule(String name, Version version, Map<String, String> headers, File location) {
        this.name = name;
        this.version = version;
        this.headers = headers;
        this.location = location;
    }

    public ConnectContent getContent() throws IOException {
        return this;
    }

    public Optional<Map<String, String>> getHeaders() {
        return Optional.of(this.headers);
    }

    public Iterable<String> getEntries() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.stream().map(ZipEntry::getName).collect(Collectors.toList());
        }
        if (this.location != null && this.location.isDirectory()) {
            try (Stream<String> stream = Files.walk(this.location.toPath(), new FileVisitOption[0]).map(p -> p.toString());){
                List<String> collect;
                List<String> list = collect = stream.collect(Collectors.toList());
                return list;
            }
        }
        return Collections.emptyList();
    }

    public Optional<ConnectContent.ConnectEntry> getEntry(String path) {
        File file;
        if (this.jarFile != null) {
            ZipEntry entry = this.jarFile.getEntry(path);
            if (entry == null) {
                return Optional.empty();
            }
            return Optional.of(new ZipConnectEntry(this.jarFile, entry));
        }
        if (this.location != null && this.location.isDirectory() && (file = new File(this.location, path)).isFile()) {
            return Optional.of(new FileConnectEntry(file));
        }
        return Optional.empty();
    }

    public Optional<ClassLoader> getClassLoader() {
        return Optional.empty();
    }

    public void open() throws IOException {
        if (this.location != null && this.jarFile == null && this.location.isFile()) {
            this.jarFile = new JarFile(this.location);
        }
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public File getLocation() {
        return this.location;
    }

    public String getId() {
        return this.name + ":" + this.version;
    }
}

