/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho;

import java.io.File;
import java.util.Objects;
import org.eclipse.tycho.ArtifactKey;

public interface ResolvedArtifactKey
extends ArtifactKey {
    public File getLocation();

    public static ResolvedArtifactKey of(ArtifactKey key, File location) {
        return ResolvedArtifactKey.of(key.getType(), key.getId(), key.getVersion(), location);
    }

    public static ResolvedArtifactKey bundle(String id, String version, File location) {
        return ResolvedArtifactKey.of("eclipse-plugin", id, version, location);
    }

    public static ResolvedArtifactKey of(final String type, final String id, final String version, final File location) {
        Objects.requireNonNull(location);
        if (!location.exists()) {
            throw new IllegalArgumentException("location " + location.getAbsolutePath() + " does not exist!");
        }
        return new ResolvedArtifactKey(){

            @Override
            public String getVersion() {
                return version;
            }

            @Override
            public String getType() {
                return type;
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public File getLocation() {
                return location;
            }

            public String toString() {
                return "[" + this.getType() + "] " + this.getId() + " " + this.getVersion() + " @ " + String.valueOf(this.getLocation());
            }
        };
    }
}

