/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.net.URI;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.RepositoryReferences;
import org.eclipse.tycho.p2.tools.TargetEnvironment;

class PublisherInfoTemplate {
    private static final boolean TARGET_REPOSITORY_COMPRESS = false;
    private static final String TARGET_REPOSITORY_NAME = "publisher repository";
    private final File targetRepository;
    private final RepositoryReferences contextRepos;
    private final BuildContext context;
    private IProvisioningAgent agent;

    public PublisherInfoTemplate(File targetRepository, RepositoryReferences contextRepos, BuildContext context, IProvisioningAgent agent) {
        this.targetRepository = targetRepository;
        this.contextRepos = contextRepos;
        this.context = context;
        this.agent = agent;
    }

    public PublisherInfo newPublisherInfo() throws FacadeException {
        this.checkRunning();
        try {
            PublisherInfo publisherInfo = new PublisherInfo();
            this.setTargetMetadataRepository(publisherInfo);
            this.setTargetArtifactRepository(publisherInfo);
            this.setContextMetadataRepos(publisherInfo);
            this.setTargetEnvironments(publisherInfo);
            return publisherInfo;
        }
        catch (ProvisionException e) {
            throw new FacadeException((Throwable)e);
        }
    }

    private void setTargetMetadataRepository(PublisherInfo publisherInfo) throws ProvisionException {
        IMetadataRepository targetMetadataRepo = Publisher.createMetadataRepository((IProvisioningAgent)this.agent, (URI)this.targetRepository.toURI(), (String)TARGET_REPOSITORY_NAME, (boolean)true, (boolean)false);
        publisherInfo.setMetadataRepository(targetMetadataRepo);
    }

    private void setTargetArtifactRepository(PublisherInfo publisherInfo) throws ProvisionException {
        IArtifactRepository targetArtifactRepo = Publisher.createArtifactRepository((IProvisioningAgent)this.agent, (URI)this.targetRepository.toURI(), (String)TARGET_REPOSITORY_NAME, (boolean)false, (boolean)false);
        publisherInfo.setArtifactRepository(targetArtifactRepo);
        publisherInfo.setArtifactOptions(3);
    }

    private void setContextMetadataRepos(PublisherInfo publisherInfo) {
        if (this.contextRepos.getMetadataRepositories().size() > 0) {
            CompositeMetadataRepository contextMetadataComposite = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            for (URI repositoryLocation : this.contextRepos.getMetadataRepositories()) {
                contextMetadataComposite.addChild(repositoryLocation);
            }
            publisherInfo.setContextMetadataRepository((IMetadataRepository)contextMetadataComposite);
        }
    }

    private void setTargetEnvironments(PublisherInfo publisherInfo) {
        int writeIx = 0;
        String[] configSpecs = new String[this.context.getEnvironments().size()];
        for (TargetEnvironment environment : this.context.getEnvironments()) {
            configSpecs[writeIx++] = environment.toConfigSpec();
        }
        publisherInfo.setConfigurations(configSpecs);
    }

    public void stopAgent() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent = null;
        }
    }

    private void checkRunning() throws IllegalStateException {
        if (this.agent == null) {
            throw new IllegalStateException("Attempt to access stopped instance");
        }
    }
}

