/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.registry.facade;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class RepositoryBlackboardKey {
    public static final String SCHEME = "file";
    private final URI uri;

    private RepositoryBlackboardKey(URI uri) {
        this.uri = uri;
    }

    public URI toURI() {
        return this.uri;
    }

    public static RepositoryBlackboardKey forResolutionContextArtifacts(File projectLocation) {
        try {
            return new RepositoryBlackboardKey(new URI(SCHEME, "/resolution-context-artifacts@" + URLEncoder.encode(String.valueOf(projectLocation), "UTF-8"), null));
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(uri=" + this.uri + ")";
    }
}

