/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;

public class AuthoredIUAction
extends AbstractPublisherAction
implements IPublisherAction {
    public static final String IU_TYPE = "org.eclipse.equinox.p2.type.iu";
    public File iuProject;

    public AuthoredIUAction(File location) {
        this.iuProject = location;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        File iuFile = new File(this.iuProject, "p2iu.xml");
        if (!iuFile.exists()) {
            return new Status(4, "org.eclipse.tycho.p2.impl", "Could not find the p2iu.xml file in folder " + this.iuProject);
        }
        try {
            FileInputStream is = new FileInputStream(iuFile);
            MetadataFactory.InstallableUnitDescription iuDescriptions = new MetadataIO().readOneIU((InputStream)is);
            this.tweakIU(iuDescriptions);
            Set<IInstallableUnit> ius = this.toIUs(iuDescriptions);
            results.addIUs(ius, "root");
            IArtifactRepository repo = info.getArtifactRepository();
            boolean artifactReferenced = false;
            if (repo != null) {
                for (IInstallableUnit iu : ius) {
                    Collection associatedKeys = iu.getArtifacts();
                    for (IArtifactKey key : associatedKeys) {
                        ArtifactDescriptor ad = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor((IPublisherInfo)info, (IArtifactKey)key, null);
                        AuthoredIUAction.processArtifactPropertiesAdvice((IInstallableUnit)iu, (IArtifactDescriptor)ad, (IPublisherInfo)info);
                        ad.setProperty("download.contentType", "application/zip");
                        ad.setProperty("maven-extension", "zip");
                        repo.addDescriptor((IArtifactDescriptor)ad);
                        artifactReferenced = true;
                    }
                }
            }
            if (!artifactReferenced && repo != null) {
                IInstallableUnit iu;
                iu = ius.iterator().next();
                ArtifactDescriptor ad = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor((IPublisherInfo)info, (IArtifactKey)new ArtifactKey("binary", "generated_" + iu.getId(), iu.getVersion()), null);
                AuthoredIUAction.processArtifactPropertiesAdvice((IInstallableUnit)iu, (IArtifactDescriptor)ad, (IPublisherInfo)info);
                ad.setProperty("download.contentType", "application/zip");
                repo.addDescriptor((IArtifactDescriptor)ad);
                artifactReferenced = true;
            }
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.tycho.p2.impl", "Error while reading " + iuFile, (Throwable)e);
        }
    }

    private Set<IInstallableUnit> toIUs(MetadataFactory.InstallableUnitDescription description) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>(1);
        result.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description));
        return result;
    }

    private void tweakIU(MetadataFactory.InstallableUnitDescription iu) {
        this.addMarkerProperty(iu);
        this.ensureSelfCapability(iu);
    }

    private void addMarkerProperty(MetadataFactory.InstallableUnitDescription iu) {
        iu.setProperty(IU_TYPE, Boolean.TRUE.toString());
    }

    private void ensureSelfCapability(MetadataFactory.InstallableUnitDescription iu) {
        Collection capabilities = iu.getProvidedCapabilities();
        for (IProvidedCapability capability : capabilities) {
            if (!"org.eclipse.equinox.p2.iu".equals(capability.getNamespace()) || !iu.getId().equals(capability.getName()) || !iu.getVersion().equals(capability.getVersion())) continue;
            return;
        }
        IProvidedCapability[] newCapabilities = new IProvidedCapability[capabilities.size() + 1];
        capabilities.toArray(newCapabilities);
        newCapabilities[newCapabilities.length - 1] = this.createSelfCapability(iu.getId(), iu.getVersion());
        iu.setCapabilities(newCapabilities);
    }
}

