/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.TargetDefinitionResolver;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;

public class TargetDefinitionResolverService {
    private static final String CACHE_MISS_MESSAGE = "Target definition content cache miss: ";
    private ConcurrentMap<ResolutionArguments, CompletableFuture<TargetDefinitionContent>> resolutionCache = new ConcurrentHashMap<ResolutionArguments, CompletableFuture<TargetDefinitionContent>>();
    private MavenContext mavenContext;
    private final AtomicReference<MavenDependenciesResolver> dependenciesResolver = new AtomicReference();

    public TargetDefinitionContent getTargetDefinitionContent(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IncludeSourceMode includeSourceMode, IProvisioningAgent agent) {
        ResolutionArguments arguments = new ResolutionArguments(definition, environments, jreIUs, includeSourceMode, agent);
        CompletableFuture future = this.resolutionCache.computeIfAbsent(arguments, this::resolveFromArguments);
        try {
            return (TargetDefinitionContent)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private CompletableFuture<TargetDefinitionContent> resolveFromArguments(ResolutionArguments arguments) {
        this.mavenContext.getLogger().info("Resolving " + arguments + "...");
        if (this.mavenContext.getLogger().isDebugEnabled()) {
            this.debugCacheMiss(arguments);
        }
        TargetDefinitionResolver resolver = new TargetDefinitionResolver(arguments.environments, arguments.jreIUs, arguments.includeSourceMode, this.mavenContext, this.dependenciesResolver.get());
        try {
            return CompletableFuture.completedFuture(resolver.resolveContent(arguments.definition, arguments.agent));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private void debugCacheMiss(ResolutionArguments arguments) {
        if (this.resolutionCache.isEmpty()) {
            return;
        }
        ArrayList<String> fieldsInWhichDistanceOneEntriesDiffer = new ArrayList<String>();
        for (ResolutionArguments existingKey : this.resolutionCache.keySet()) {
            List<String> differingFields = arguments.getNonEqualFields(existingKey);
            if (differingFields.size() != 1) continue;
            fieldsInWhichDistanceOneEntriesDiffer.add(differingFields.get(0));
        }
        if (fieldsInWhichDistanceOneEntriesDiffer.isEmpty()) {
            this.mavenContext.getLogger().debug("Target definition content cache miss: All entries differ in more than one parameter");
        } else {
            this.mavenContext.getLogger().debug("Target definition content cache miss: All entries differ, but there are entries which only differ in one parameter: " + fieldsInWhichDistanceOneEntriesDiffer);
        }
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setMavenDependenciesResolver(MavenDependenciesResolver mavenDependenciesResolver) {
        this.dependenciesResolver.set(mavenDependenciesResolver);
    }

    public void unsetMavenDependenciesResolver(MavenDependenciesResolver mavenDependenciesResolver) {
        this.dependenciesResolver.compareAndSet(mavenDependenciesResolver, null);
    }

    static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    static <T> void addIfNonEqual(List<String> result, String stringToAdd, T left, T right) {
        if (!TargetDefinitionResolverService.eq(left, right)) {
            result.add(stringToAdd);
        }
    }

    private static final class ResolutionArguments {
        final TargetDefinition definition;
        final List<TargetEnvironment> environments;
        final ExecutionEnvironmentResolutionHints jreIUs;
        final IProvisioningAgent agent;
        private IncludeSourceMode includeSourceMode;

        public ResolutionArguments(TargetDefinition definition, List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints jreIUs, IncludeSourceMode includeSourceMode, IProvisioningAgent agent) {
            this.definition = definition;
            this.environments = environments;
            this.jreIUs = jreIUs;
            this.includeSourceMode = includeSourceMode;
            this.agent = agent;
        }

        public int hashCode() {
            int prime = 61;
            int result = 1;
            result = 61 * result + (this.agent == null ? 0 : this.agent.hashCode());
            result = 61 * result + (this.definition == null ? 0 : this.definition.hashCode());
            result = 61 * result + (this.environments == null ? 0 : this.environments.hashCode());
            result = 61 * result + (this.jreIUs == null ? 0 : this.jreIUs.hashCode());
            result = 61 * result + (this.includeSourceMode == null ? 0 : this.includeSourceMode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResolutionArguments)) {
                return false;
            }
            ResolutionArguments other = (ResolutionArguments)obj;
            return TargetDefinitionResolverService.eq(this.jreIUs, other.jreIUs) && TargetDefinitionResolverService.eq(this.definition, other.definition) && TargetDefinitionResolverService.eq(this.agent, other.agent) && TargetDefinitionResolverService.eq(this.environments, other.environments) && TargetDefinitionResolverService.eq(this.includeSourceMode, other.includeSourceMode);
        }

        public List<String> getNonEqualFields(ResolutionArguments other) {
            ArrayList<String> result = new ArrayList<String>();
            TargetDefinitionResolverService.addIfNonEqual(result, "target definition", this.definition, other.definition);
            TargetDefinitionResolverService.addIfNonEqual(result, "execution environment", this.jreIUs, other.jreIUs);
            TargetDefinitionResolverService.addIfNonEqual(result, "target environments", this.environments, other.environments);
            TargetDefinitionResolverService.addIfNonEqual(result, "remote p2 repository options", this.agent, other.agent);
            TargetDefinitionResolverService.addIfNonEqual(result, "include source mode", this.includeSourceMode, other.includeSourceMode);
            return result;
        }

        public String toString() {
            return "target definition " + this.definition.getOrigin() + " for environments=" + this.environments + ", include source mode=" + this.includeSourceMode + ", execution environment=" + this.jreIUs + ", remote p2 repository options=" + this.agent;
        }
    }
}

