/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.impl.Activator;
import org.eclipse.tycho.p2.remote.P2MirrorDisablingArtifactRepositoryManager;
import org.eclipse.tycho.p2.remote.RemoteArtifactRepositoryManager;
import org.eclipse.tycho.p2.remote.RemoteMetadataRepositoryManager;
import org.eclipse.tycho.p2.remote.TychoRepositoryTransport;
import org.eclipse.tycho.p2.remote.TychoRepositoryTransportCacheManager;

public class RemoteAgent
implements IProvisioningAgent {
    private IProvisioningAgent delegate;

    public RemoteAgent(MavenContext mavenContext, IProxyService proxyService, MavenRepositorySettings mavenRepositorySettings, boolean disableMirrors) throws ProvisionException {
        this.delegate = RemoteAgent.createConfiguredProvisioningAgent(mavenContext, proxyService, disableMirrors, mavenRepositorySettings);
    }

    RemoteAgent(MavenContext mavenContext, boolean disableP2Mirrors) throws ProvisionException {
        this(mavenContext, null, null, disableP2Mirrors);
    }

    public RemoteAgent(MavenContext mavenContext) throws ProvisionException {
        this(mavenContext, null, null, false);
    }

    private static IProvisioningAgent createConfiguredProvisioningAgent(MavenContext mavenContext, IProxyService proxyService, boolean disableP2Mirrors, MavenRepositorySettings mavenRepositorySettings) throws ProvisionException {
        AgentBuilder agent = new AgentBuilder(Activator.newProvisioningAgent());
        TychoRepositoryTransport tychoRepositoryTransport = new TychoRepositoryTransport(mavenContext, proxyService, uri -> {
            if (mavenRepositorySettings == null) {
                return null;
            }
            IRepositoryIdManager repositoryIdManager = agent.getService(IRepositoryIdManager.class);
            Stream locations = mavenContext.getMavenRepositoryLocations();
            locations = Stream.concat(locations, repositoryIdManager.getKnownMavenRepositoryLocations());
            String requestUri = uri.normalize().toASCIIString();
            return locations.sorted((loc1, loc2) -> {
                String s1 = loc1.getURL().normalize().toASCIIString();
                String s2 = loc2.getURL().normalize().toASCIIString();
                return Long.compare(s2.length(), s1.length());
            }).filter(loc -> {
                String prefix = loc.getURL().normalize().toASCIIString();
                return requestUri.startsWith(prefix);
            }).map(arg_0 -> ((MavenRepositorySettings)mavenRepositorySettings).getCredentials(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
        });
        agent.getAgent().registerService(CacheManager.SERVICE_NAME, (Object)new TychoRepositoryTransportCacheManager(tychoRepositoryTransport, mavenContext));
        agent.getAgent().registerService(Transport.SERVICE_NAME, (Object)tychoRepositoryTransport);
        if (disableP2Mirrors) {
            RemoteAgent.addP2MirrorDisablingRepositoryManager(agent, mavenContext.getLogger());
        }
        if (mavenRepositorySettings != null) {
            agent.registerService(MavenRepositorySettings.class, mavenRepositorySettings);
            RemoteAgent.addMavenAwareRepositoryManagers(agent, mavenRepositorySettings, mavenContext.getLogger());
        }
        RemoteAgent.makeCompositeRepositoryLoadingAtomicByDefault();
        return agent.getAgent();
    }

    private static void addP2MirrorDisablingRepositoryManager(AgentBuilder agent, MavenLogger mavenLogger) {
        IArtifactRepositoryManager plainRepoManager = agent.getService(IArtifactRepositoryManager.class);
        P2MirrorDisablingArtifactRepositoryManager mirrorDisablingRepoManager = new P2MirrorDisablingArtifactRepositoryManager(plainRepoManager, mavenLogger);
        agent.registerService(IArtifactRepositoryManager.class, mirrorDisablingRepoManager);
    }

    private static void addMavenAwareRepositoryManagers(AgentBuilder agent, MavenRepositorySettings mavenRepositorySettings, MavenLogger logger) {
        IRepositoryIdManager loadingHelper = (IRepositoryIdManager)agent.getAgent().getService(IRepositoryIdManager.class);
        IMetadataRepositoryManager plainMetadataRepoManager = agent.getService(IMetadataRepositoryManager.class);
        RemoteMetadataRepositoryManager remoteMetadataRepoManager = new RemoteMetadataRepositoryManager(plainMetadataRepoManager, loadingHelper, logger);
        agent.registerService(IMetadataRepositoryManager.class, remoteMetadataRepoManager);
        IArtifactRepositoryManager plainArtifactRepoManager = agent.getService(IArtifactRepositoryManager.class);
        RemoteArtifactRepositoryManager remoteArtifactRepoManager = new RemoteArtifactRepositoryManager(plainArtifactRepoManager, loadingHelper);
        agent.registerService(IArtifactRepositoryManager.class, remoteArtifactRepoManager);
    }

    private static void makeCompositeRepositoryLoadingAtomicByDefault() {
        String atomicDefaultSystemProperty = "eclipse.p2.atomic.composite.loading.default";
        if (System.getProperty(atomicDefaultSystemProperty) == null) {
            System.setProperty(atomicDefaultSystemProperty, Boolean.toString(true));
        }
    }

    public Object getService(String serviceName) {
        return this.delegate.getService(serviceName);
    }

    public void registerService(String serviceName, Object service) {
        this.delegate.registerService(serviceName, service);
    }

    public <T> T getService(Class<T> type) {
        return type.cast(this.getService(type.getName()));
    }

    public void stop() {
        this.delegate.stop();
    }

    public void unregisterService(String serviceName, Object service) {
        this.delegate.unregisterService(serviceName, service);
    }

    static class AgentBuilder {
        private final IProvisioningAgent wrappedAgent;

        public AgentBuilder(IProvisioningAgent wrappedAgent) {
            this.wrappedAgent = wrappedAgent;
        }

        public <T> T getService(Class<T> type) {
            return type.cast(this.wrappedAgent.getService(type.getName()));
        }

        public <T> void registerService(Class<T> type, T instance) {
            this.wrappedAgent.registerService(type.getName(), instance);
        }

        public IProvisioningAgent getAgent() {
            return this.wrappedAgent;
        }
    }
}

