/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.ee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.osgi.framework.BundleException;

public final class StandardEEResolutionHints
implements ExecutionEnvironmentResolutionHints {
    private final Map<VersionedId, IInstallableUnit> additionalUnits;
    private final Map<VersionedId, IInstallableUnit> temporaryUnits;
    private final ExecutionEnvironment executionEnvironment;

    public StandardEEResolutionHints(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.additionalUnits = StandardEEResolutionHints.computeAdditionalUnits(executionEnvironment);
        this.temporaryUnits = this.computeTemporaryAdditions(this.additionalUnits);
    }

    @Override
    public boolean isNonApplicableEEUnit(IInstallableUnit iu) {
        return iu.getId().startsWith("a.jre") || iu.getId().startsWith("config.a.jre");
    }

    @Override
    public boolean isEESpecificationUnit(IInstallableUnit unit) {
        throw new UnsupportedOperationException();
    }

    private static Map<VersionedId, IInstallableUnit> computeAdditionalUnits(ExecutionEnvironment executionEnvironment) {
        LinkedHashMap<VersionedId, IInstallableUnit> units = new LinkedHashMap<VersionedId, IInstallableUnit>();
        StandardEEResolutionHints.addIUsFromEnvironment(executionEnvironment, units);
        return units;
    }

    static void addIUsFromEnvironment(ExecutionEnvironment executionEnvironment, Map<VersionedId, IInstallableUnit> units) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(false);
        String[] segements = executionEnvironment.getProfileName().split("-");
        iu.setId("a.jre." + segements[0].toLowerCase());
        iu.setVersion(Version.create((String)segements[segements.length - 1]));
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(PublisherHelper.createSelfCapability((String)iu.getId(), (Version)iu.getVersion()));
        executionEnvironment.getSystemPackages().stream().map(systemPackage -> MetadataFactory.createProvidedCapability((String)"java.package", (String)systemPackage.packageName, (Version)Version.create((String)(systemPackage.version == null ? "0.0.0" : systemPackage.version)))).forEach(capabilities::add);
        String systemCapabilities = executionEnvironment.getProfileProperties().getProperty("org.osgi.framework.system.capabilities");
        capabilities.addAll(StandardEEResolutionHints.parseSystemCapabilities(systemCapabilities));
        iu.setCapabilities((IProvidedCapability[])capabilities.toArray(IProvidedCapability[]::new));
        StandardEEResolutionHints.put(units, MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
    }

    @Override
    public Collection<IInstallableUnit> getMandatoryUnits() {
        return this.additionalUnits.values();
    }

    @Override
    public Collection<IRequirement> getMandatoryRequires() {
        return Collections.emptyList();
    }

    private Map<VersionedId, IInstallableUnit> computeTemporaryAdditions(Map<VersionedId, IInstallableUnit> additionalUnits) {
        return Collections.emptyMap();
    }

    @Override
    public Collection<IInstallableUnit> getTemporaryAdditions() {
        return this.temporaryUnits.values();
    }

    private static void put(Map<VersionedId, IInstallableUnit> units, IInstallableUnit unit) {
        units.put(new VersionedId(unit.getId(), unit.getVersion()), unit);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.executionEnvironment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StandardEEResolutionHints)) {
            return false;
        }
        StandardEEResolutionHints other = (StandardEEResolutionHints)obj;
        return Objects.equals(this.executionEnvironment, other.executionEnvironment);
    }

    static Collection<IProvidedCapability> parseSystemCapabilities(String systemCapabilities) {
        if (systemCapabilities == null || systemCapabilities.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(ManifestElement.parseHeader((String)"org.osgi.framework.system.capabilities", (String)systemCapabilities)).flatMap(eeCapability -> {
                String eeName = eeCapability.getAttribute("osgi.ee");
                if (eeName == null) {
                    return Stream.empty();
                }
                return StandardEEResolutionHints.parseEECapabilityVersion(eeCapability).map(version -> MetadataFactory.createProvidedCapability((String)"osgi.ee", (String)eeName, (Version)version));
            }).collect(Collectors.toList());
        }
        catch (BundleException e) {
            return Collections.emptyList();
        }
    }

    private static Stream<Version> parseEECapabilityVersion(ManifestElement eeCapability) {
        String singleVersion = eeCapability.getAttribute("version:Version");
        String[] multipleVersions = ManifestElement.getArrayFromList((String)eeCapability.getAttribute("version:List<Version>"));
        if (singleVersion == null && multipleVersions == null) {
            return Stream.empty();
        }
        if (singleVersion == null) {
            return Arrays.stream(multipleVersions).map(Version::parseVersion);
        }
        if (multipleVersions == null) {
            return Stream.of(singleVersion).map(Version::parseVersion);
        }
        return Stream.empty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StandardEEResolutionHints [executionEnvironment=");
        builder.append(this.executionEnvironment);
        builder.append("]");
        return builder.toString();
    }
}

