/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfigurationStub;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.resolver.DefaultP2ResolutionResult;
import org.eclipse.tycho.p2.resolver.MetadataOnlyP2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.target.TargetPlatformFactoryImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.DependencyCollector;
import org.eclipse.tycho.p2.util.resolution.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolutionDataImpl;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.metadata.QueryableCollection;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

public class P2ResolverImpl
implements P2Resolver {
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private List<TargetEnvironment> environments;
    private Map<String, String> additionalFilterProperties = new HashMap<String, String>();
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private TargetPlatformFactoryImpl targetPlatformFactory;
    private P2TargetPlatform context;
    private Set<IInstallableUnit> currentProjectUnits;
    private Set<IInstallableUnit> usedTargetPlatformUnits;

    public P2ResolverImpl(TargetPlatformFactoryImpl targetPlatformFactory, MavenLogger logger) {
        this.targetPlatformFactory = targetPlatformFactory;
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.environments = Collections.singletonList(TargetEnvironment.getRunningEnvironment());
    }

    private void setContext(TargetPlatform targetPlatform, ReactorProject currentProject) {
        this.context = (P2TargetPlatform)targetPlatform;
        this.currentProjectUnits = currentProject == null ? Collections.emptySet() : currentProject.getDependencyMetadata();
    }

    public Map<TargetEnvironment, P2ResolutionResult> resolveTargetDependencies(TargetPlatform targetPlatform, ReactorProject project) {
        this.setContext(targetPlatform, project);
        if (project != null && "eclipse-test-plugin".equals(project.getPackaging())) {
            this.addDependenciesForTests();
        }
        LinkedHashMap<TargetEnvironment, P2ResolutionResult> results = new LinkedHashMap<TargetEnvironment, P2ResolutionResult>();
        this.usedTargetPlatformUnits = new LinkedHashSet<IInstallableUnit>();
        Set metadata = project != null ? project.getDependencyMetadata(true) : Collections.emptySet();
        for (TargetEnvironment environment : this.environments) {
            if (this.isMatchingEnv(metadata, environment)) {
                results.put(environment, this.resolveDependencies(project, new ProjectorResolutionStrategy(this.logger), environment));
                continue;
            }
            this.logger.info(MessageFormat.format("Project {0}:{1}:{2} does not match environment {3} skipp dependecy resolution", project.getGroupId(), project.getArtifactId(), project.getVersion(), environment.toFilterExpression()));
        }
        this.context.reportUsedLocalIUs(this.usedTargetPlatformUnits);
        this.usedTargetPlatformUnits = null;
        return results;
    }

    private boolean isMatchingEnv(Set<?> metadata, TargetEnvironment environment) {
        if (metadata != null) {
            for (Object meta : metadata) {
                IMatchExpression filter;
                if (!(meta instanceof IInstallableUnit) || (filter = ((IInstallableUnit)meta).getFilter()) == null) continue;
                boolean match = filter.isMatch((Object)InstallableUnit.contextIU((Map)environment.toFilterProperties()));
                this.logger.debug(MessageFormat.format("{0}: {1} (matches {2})", filter, Arrays.toString(filter.getParameters()), match));
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public P2ResolutionResult collectProjectDependencies(TargetPlatform targetPlatform, ReactorProject project) {
        this.setContext(targetPlatform, project);
        return this.resolveDependencies(project, new DependencyCollector(this.logger), new TargetEnvironment(null, null, null));
    }

    public P2ResolutionResult resolveMetadata(TargetPlatformConfigurationStub tpConfiguration, String eeName) {
        TargetPlatform contextImpl = this.targetPlatformFactory.createTargetPlatform(tpConfiguration, (ExecutionEnvironmentConfiguration)new ExecutionEnvironmentConfigurationStub(eeName), (List)null, (PomDependencyCollector)null);
        ResolutionDataImpl data = new ResolutionDataImpl(contextImpl.getEEResolutionHints());
        data.setAvailableIUs(contextImpl.getInstallableUnits());
        data.setRootIUs(new HashSet<IInstallableUnit>());
        data.setAdditionalRequirements(this.additionalRequirements);
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        strategy.setData(data);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        try {
            for (IInstallableUnit iu : strategy.multiPlatformResolve(this.environments, this.monitor)) {
                result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
            }
        }
        catch (ResolverException e) {
            this.logger.error("Resolution failed:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            throw new RuntimeException(e);
        }
        return result;
    }

    public P2ResolutionResult getTargetPlatformAsResolutionResult(TargetPlatformConfigurationStub tpConfiguration, String eeName) {
        TargetPlatform targetPlatform = this.targetPlatformFactory.createTargetPlatform(tpConfiguration, (ExecutionEnvironmentConfiguration)new ExecutionEnvironmentConfigurationStub(eeName), (List)null, (PomDependencyCollector)null);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        for (IInstallableUnit iu : targetPlatform.getInstallableUnits()) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveDependencies(ReactorProject project, AbstractResolutionStrategy strategy, TargetEnvironment environment) {
        Collection<IInstallableUnit> newState;
        ResolutionDataImpl data = new ResolutionDataImpl(this.context.getEEResolutionHints());
        Set<IInstallableUnit> availableUnits = this.context.getInstallableUnits();
        if (project != null) {
            data.setRootIUs(project.getDependencyMetadata(true));
            Set projectSecondaryIUs = project.getDependencyMetadata(false);
            if (!projectSecondaryIUs.isEmpty()) {
                availableUnits = new LinkedHashSet<IInstallableUnit>(availableUnits);
                availableUnits.addAll(projectSecondaryIUs);
            }
        } else {
            data.setRootIUs(Collections.emptySet());
        }
        data.setAdditionalRequirements(this.additionalRequirements);
        data.setAvailableIUs(availableUnits);
        data.setAdditionalFilterProperties(this.additionalFilterProperties);
        strategy.setData(data);
        try {
            newState = strategy.resolve(environment, this.monitor);
        }
        catch (ResolverException e) {
            this.logger.info(e.getSelectionContext());
            this.logger.error("Cannot resolve project dependencies:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            this.logger.error("");
            this.logger.error("See https://wiki.eclipse.org/Tycho/Dependency_Resolution_Troubleshooting for help.");
            throw new DependencyResolutionException("Cannot resolve dependencies of " + project, (Throwable)e);
        }
        if (this.usedTargetPlatformUnits != null) {
            this.usedTargetPlatformUnits.addAll(newState);
        }
        return this.toResolutionResult(newState, project);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> newState, ReactorProject currentProject) {
        DefaultP2ResolutionResult result = new DefaultP2ResolutionResult();
        TreeSet<String> missingArtifacts = new TreeSet<String>();
        for (IInstallableUnit iu : newState) {
            this.addUnit(result, iu, currentProject, missingArtifacts);
        }
        result.removeEntriesWithUnknownType();
        this.context.saveLocalMavenRepository();
        this.failIfArtifactsMissing(missingArtifacts);
        this.collectNonReactorIUs(result, newState);
        return result;
    }

    private void addUnit(DefaultP2ResolutionResult result, IInstallableUnit iu, ReactorProject currentProject, Set<String> missingArtifacts) {
        if (this.currentProjectUnits.contains(iu)) {
            this.addReactorProject(result, currentProject.getIdentities(), iu);
            return;
        }
        ReactorProjectIdentities otherProject = this.context.getOriginalReactorProjectMap().get(iu);
        if (otherProject != null) {
            this.addReactorProject(result, otherProject, iu);
            return;
        }
        IArtifactFacade mavenArtifact = this.context.getOriginalMavenArtifactMap().get(iu);
        if (mavenArtifact != null) {
            this.addExternalMavenArtifact(result, mavenArtifact, iu);
            return;
        }
        for (IArtifactKey key : iu.getArtifacts()) {
            File artifactLocation = this.context.getLocalArtifactFile(key);
            if (artifactLocation == null) {
                missingArtifacts.add(key.toString());
                continue;
            }
            this.addArtifactFile(result, iu, key, artifactLocation);
        }
    }

    private void failIfArtifactsMissing(Set<String> missingArtifacts) {
        if (!missingArtifacts.isEmpty()) {
            this.logger.error("The following artifacts could not be downloaded: ");
            for (String missingArtifact : missingArtifacts) {
                this.logger.error("  " + missingArtifact);
            }
            throw new RuntimeException("Some required artifacts could not be downloaded. See log output for details.");
        }
    }

    private void collectNonReactorIUs(DefaultP2ResolutionResult result, Collection<IInstallableUnit> newState) {
        Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup = this.context.getOriginalReactorProjectMap();
        for (IInstallableUnit iu : newState) {
            if (this.currentProjectUnits.contains(iu) || reactorProjectLookup.get(iu) != null) continue;
            result.addNonReactorUnit(iu);
        }
    }

    private void addArtifactFile(DefaultP2ResolutionResult result, IInstallableUnit iu, IArtifactKey key, File artifactLocation) {
        String featureId;
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = null;
        if ("osgi.bundle".equals(key.getClassifier())) {
            result.addArtifact("eclipse-plugin", id, version, artifactLocation, mavenClassifier, iu);
        } else if ("org.eclipse.update.feature".equals(key.getClassifier()) && (featureId = this.getFeatureId(iu)) != null) {
            result.addArtifact("eclipse-feature", featureId, version, artifactLocation, mavenClassifier, iu);
        }
    }

    private void addReactorProject(DefaultP2ResolutionResult result, ReactorProjectIdentities project, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = project.getBasedir();
        this.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    private void addExternalMavenArtifact(DefaultP2ResolutionResult result, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = mavenArtifact.getLocation();
        this.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    protected void addMavenArtifact(DefaultP2ResolutionResult result, IInstallableUnit iu, String id, String version, String mavenClassifier, File location) {
        String contributingArtifactId;
        String contributingArtifactType;
        if (this.isBundleOrFragmentWithId(iu, id)) {
            contributingArtifactType = "eclipse-plugin";
            contributingArtifactId = id;
        } else {
            String featureId = this.getFeatureId(iu);
            if (featureId != null) {
                contributingArtifactType = "eclipse-feature";
                contributingArtifactId = featureId;
            } else if (this.isProduct(iu)) {
                contributingArtifactType = "eclipse-product";
                contributingArtifactId = id;
            } else if (this.isPureIU(iu)) {
                contributingArtifactType = "p2-installable-unit";
                contributingArtifactId = id;
            } else {
                contributingArtifactType = null;
                contributingArtifactId = null;
            }
        }
        result.addArtifact(contributingArtifactType, contributingArtifactId, version, location, mavenClassifier, iu);
    }

    private boolean isPureIU(IInstallableUnit iu) {
        return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.iu"));
    }

    private String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    private boolean isBundleOrFragmentWithId(IInstallableUnit iu, String id) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"osgi.bundle".equals(provided.getNamespace())) continue;
            return id.equals(provided.getName());
        }
        return false;
    }

    private boolean isProduct(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.product"));
    }

    public void setEnvironments(List<TargetEnvironment> environments) {
        if (environments == null) {
            throw new NullPointerException();
        }
        this.environments = environments;
    }

    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        if (additionalFilterProperties == null) {
            throw new NullPointerException();
        }
        this.additionalFilterProperties = additionalFilterProperties;
    }

    public void addDependency(String type, String id, String versionRange) throws IllegalArtifactReferenceException {
        VersionRange parsedVersionRange;
        try {
            parsedVersionRange = new VersionRange(versionRange);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArtifactReferenceException("The string \"" + versionRange + "\" is not a valid OSGi version range");
        }
        this.additionalRequirements.add(ArtifactTypeHelper.createRequirementFor(type, id, parsedVersionRange));
    }

    private void addDependenciesForTests() {
        this.additionalRequirements.add(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.equinox.launcher"));
        this.additionalRequirements.add(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.core.runtime"));
        this.additionalRequirements.add(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.ui.ide.application"));
    }

    private static IRequirement optionalGreedyRequirementTo(String bundleId) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleId, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true, (boolean)true);
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public P2ResolutionResult resolveInstallableUnit(TargetPlatform targetPlatform, String id, String versionRange) {
        this.setContext(targetPlatform, null);
        QueryableCollection queriable = new QueryableCollection(this.context.getInstallableUnits());
        VersionRange range = new VersionRange(versionRange);
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
        Set newState = result.toUnmodifiableSet();
        return this.toResolutionResult(newState, null);
    }
}

