/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.LinkedHashSet;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;

public class ArtifactMatcher {
    public static IInstallableUnit resolveReference(String type, String id, Version version, LinkedHashSet<IInstallableUnit> candidateUnits) throws IllegalArtifactReferenceException {
        if (id == null) {
            throw new IllegalArtifactReferenceException("ID is required");
        }
        VersionRange versionRange = ArtifactMatcher.getVersionRangeFromReference(version);
        IQuery query = QueryUtil.createLatestQuery(ArtifactTypeHelper.createQueryFor(type, id, versionRange));
        IQueryResult matchingIUs = query.perform(candidateUnits.iterator());
        if (matchingIUs.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)matchingIUs.iterator().next();
    }

    public static Version parseAsOSGiVersion(String version) throws IllegalArtifactReferenceException {
        try {
            return Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArtifactReferenceException("The string \"" + version + "\" is not a valid OSGi version");
        }
    }

    private static VersionRange getVersionRangeFromReference(Version version) {
        VersionRange range = version.getSegmentCount() > 3 && "qualifier".equals(version.getSegment(3)) ? ArtifactMatcher.getRangeOfEquivalentVersions(version) : (Version.emptyVersion.equals(version) ? VersionRange.emptyRange : ArtifactMatcher.getStrictRange(version));
        return range;
    }

    private static VersionRange getStrictRange(Version version) {
        return new VersionRange(version, true, version, true);
    }

    private static VersionRange getRangeOfEquivalentVersions(Version version) {
        Integer major = (Integer)version.getSegment(0);
        Integer minor = (Integer)version.getSegment(1);
        Integer micro = (Integer)version.getSegment(2);
        VersionRange range = new VersionRange(Version.createOSGi((int)major, (int)minor, (int)micro), true, Version.createOSGi((int)major, (int)minor, (int)(micro + 1)), false);
        return range;
    }
}

