/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.tycho.core.shared.MavenLogger;

class P2PasswordUtil {
    P2PasswordUtil() {
    }

    static void setCredentials(URI location, String username, String password, MavenLogger logger) {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        String host = location.getHost();
        if (host == null) {
            String scheme = location.getScheme();
            host = URIUtil.isFileURI((URI)location) || scheme == null ? new Path(location.toString()).removeLastSegments(1).toString() : location.toString();
        }
        try {
            nodeKey = URLEncoder.encode(host, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            try {
                String enc = System.getProperty("file.encoding");
                if (enc == null) {
                    throw new UnsupportedEncodingException("No UTF-8 encoding and missing system property: file.encoding");
                }
                nodeKey = URLEncoder.encode(host, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        String nodeName = "org.eclipse.equinox.p2.repository/" + nodeKey;
        ISecurePreferences prefNode = securePreferences.node(nodeName);
        try {
            if (!username.equals(prefNode.get("username", username)) || !password.equals(prefNode.get("password", password))) {
                logger.info("Redefining access credentials for repository host " + host);
            }
            prefNode.put("username", username, false);
            prefNode.put("password", password, false);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }
}

