/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractFileSet {
    private static final String ZERO_OR_MORE_DIRS = "([^/]+/)*";
    private static final String ZERO_OR_MORE_FILE_CHARACTERS = "[^/]*";
    private static final String ONE_CHARACTER = ".";
    private static final String QUOTE_BEGIN = "\\Q";
    private static final String QUOTE_END = "\\E";
    private static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected Pattern includePattern;
    protected List<Pattern> defaultExcludePatterns;
    private boolean useDefaultExcludes;

    public AbstractFileSet(String pattern, boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
        this.includePattern = this.convertToRegexPattern(pattern);
        this.defaultExcludePatterns = this.createDefaultExcludePatterns();
        this.defaultExcludePatterns = this.createDefaultExcludePatterns();
    }

    private List<Pattern> createDefaultExcludePatterns() {
        ArrayList<Pattern> defaultExcludePatterns = new ArrayList<Pattern>();
        String[] stringArray = DEFAULTEXCLUDES;
        int n = DEFAULTEXCLUDES.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            defaultExcludePatterns.add(this.convertToRegexPattern(exclude));
            ++n2;
        }
        return defaultExcludePatterns;
    }

    private Pattern convertToRegexPattern(String antFilePattern) {
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE_BEGIN);
        char[] chars = antFilePattern.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '?': {
                    sb.append("\\E.\\Q");
                    break;
                }
                case '*': {
                    sb.append(QUOTE_END);
                    if (i + 1 < chars.length && chars[i + 1] == '*') {
                        sb.append(ZERO_OR_MORE_DIRS);
                        if (++i + 1 < chars.length && chars[i + 1] == '/') {
                            ++i;
                        }
                        if (i == chars.length - 1) {
                            sb.append(ZERO_OR_MORE_FILE_CHARACTERS);
                        }
                    } else {
                        sb.append(ZERO_OR_MORE_FILE_CHARACTERS);
                    }
                    sb.append(QUOTE_BEGIN);
                    break;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
            ++i;
        }
        sb.append(QUOTE_END);
        return Pattern.compile(sb.toString());
    }

    protected boolean matches(IPath path) {
        String slashifiedPath = path.toPortableString();
        if (this.useDefaultExcludes) {
            for (Pattern excludePattern : this.defaultExcludePatterns) {
                if (!excludePattern.matcher(slashifiedPath).matches()) continue;
                return false;
            }
        }
        return this.includePattern.matcher(slashifiedPath).matches();
    }
}

