/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.AbstractFileSet;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FileToPathMap;

public class FileSet
extends AbstractFileSet {
    private File baseDir;

    public FileSet(File baseDir, String pattern) {
        this(baseDir, pattern, true);
    }

    public FileSet(File baseDir, String pattern, boolean useDefaultExcludes) {
        super(pattern, useDefaultExcludes);
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public FileToPathMap scan() {
        FileToPathMap result = new FileToPathMap();
        this.recursiveScan(this.baseDir, result, Path.fromOSString((String)this.baseDir.getAbsolutePath()));
        return result;
    }

    private void recursiveScan(File file, FileToPathMap result, IPath baseDirPath) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                if (subFile.isDirectory()) {
                    this.recursiveScan(subFile, result, baseDirPath);
                } else if (subFile.isFile()) {
                    this.addFileIfMatch(subFile, result, baseDirPath);
                }
                ++n2;
            }
        } else if (file.isFile()) {
            this.addFileIfMatch(file, result, baseDirPath);
        }
    }

    private void addFileIfMatch(File file, FileToPathMap result, IPath baseDir) {
        IPath relativePath = Path.fromOSString((String)file.getAbsolutePath()).makeRelativeTo(baseDir);
        if (this.matches(relativePath)) {
            result.put(file, relativePath);
        }
    }
}

