/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenLogger;

class RemoteRepositoryCacheManager
extends CacheManager {
    public static final String CACHE_RELPATH = ".cache/tycho/p2-repository-metadata";
    private final boolean offline;
    private final File localRepositoryLocation;
    private final MavenLogger logger;

    public RemoteRepositoryCacheManager(Transport transport, MavenContext mavenContext) {
        super(null, transport);
        this.localRepositoryLocation = mavenContext.getLocalRepositoryRoot();
        this.offline = mavenContext.isOffline();
        this.logger = mavenContext.getLogger();
        if (this.logger == null) {
            throw new NullPointerException();
        }
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        File cacheFile = this.getCache(repositoryLocation, prefix);
        if (this.offline) {
            if (cacheFile != null) {
                return cacheFile;
            }
            throw new ProvisionException("Repository system is offline and no local cache available for " + repositoryLocation.toString());
        }
        try {
            return super.createCache(repositoryLocation, prefix, monitor);
        }
        catch (IOException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
        catch (ProvisionException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
    }

    private <T extends Exception> File handleCreateCacheException(File cacheFile, URI repositoryLocation, T e) throws T {
        if (cacheFile != null) {
            String message = "Failed to access p2 repository " + repositoryLocation.toASCIIString() + ", use local cache.";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(message, e);
            } else {
                message = String.valueOf(message) + " " + e.getMessage();
                this.logger.warn(message);
            }
            return cacheFile;
        }
        throw e;
    }

    protected File getCacheDirectory() {
        return new File(this.localRepositoryLocation, CACHE_RELPATH);
    }
}

